/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import java.util.List;

public class ExportParameterVisitorUtils {
    public static boolean exportParamterAndAccept(List<Object> parameters2, List<SQLExpr> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            SQLExpr param = list.get(i);
            SQLExpr result2 = ExportParameterVisitorUtils.exportParameter(parameters2, param);
            if (result2 == param) continue;
            list.set(i, result2);
        }
        return false;
    }

    public static SQLExpr exportParameter(List<Object> parameters2, SQLExpr param) {
        if (param instanceof SQLCharExpr) {
            String value = ((SQLCharExpr)param).getText();
            parameters2.add(value);
            return new SQLVariantRefExpr("?");
        }
        if (param instanceof SQLBooleanExpr) {
            Boolean value = ((SQLBooleanExpr)param).getValue();
            parameters2.add(value);
            return new SQLVariantRefExpr("?");
        }
        if (param instanceof SQLNumericLiteralExpr) {
            Number value = ((SQLNumericLiteralExpr)param).getNumber();
            parameters2.add(value);
            return new SQLVariantRefExpr("?");
        }
        return param;
    }

    public static void exportParameter(List<Object> parameters2, SQLBinaryOpExpr x) {
        SQLExpr rightResult;
        if (x.getLeft() instanceof SQLLiteralExpr && x.getRight() instanceof SQLLiteralExpr && x.getOperator().isRelational()) {
            return;
        }
        SQLExpr leftResult = ExportParameterVisitorUtils.exportParameter(parameters2, x.getLeft());
        if (leftResult != x.getLeft()) {
            x.setLeft(leftResult);
        }
        if ((rightResult = ExportParameterVisitorUtils.exportParameter(parameters2, x.getRight())) != x.getRight()) {
            x.setRight(rightResult);
        }
    }

    public static void exportParameter(List<Object> parameters2, SQLBetweenExpr x) {
        SQLExpr result2 = ExportParameterVisitorUtils.exportParameter(parameters2, x.getBeginExpr());
        if (result2 != x.getBeginExpr()) {
            x.setBeginExpr(result2);
        }
        if ((result2 = ExportParameterVisitorUtils.exportParameter(parameters2, x.getEndExpr())) != x.getBeginExpr()) {
            x.setEndExpr(result2);
        }
    }
}

