/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLSelectItem
extends SQLObjectImpl {
    private SQLExpr expr;
    private String alias;
    private boolean connectByRoot = false;

    public SQLSelectItem() {
    }

    public SQLSelectItem(SQLExpr expr) {
        this(expr, null);
    }

    public SQLSelectItem(SQLExpr expr, String alias) {
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLSelectItem(SQLExpr expr, String alias, boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        this.expr = expr;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.connectByRoot) {
            buf.append(" CONNECT_BY_ROOT ");
        }
        this.expr.output(buf);
        if (this.alias != null && this.alias.length() != 0) {
            buf.append(" AS ");
            buf.append(this.alias);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor2) {
        if (visitor2.visit(this)) {
            this.acceptChild(visitor2, this.expr);
        }
        visitor2.endVisit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.alias == null ? 0 : this.alias.hashCode());
        result2 = 31 * result2 + (this.expr == null ? 0 : this.expr.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLSelectItem other = (SQLSelectItem)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
    }

    public boolean isConnectByRoot() {
        return this.connectByRoot;
    }

    public void setConnectByRoot(boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
    }
}

