# Copyright 2016 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license

%define        __spec_install_post %{nil}
%define          debug_package %{nil}
%define        __os_install_post %{_dbpath}/brp-compress

Name:           ovirt-provider-ovn
Version:        1.0.9
Release:        0%{?dist}
Summary:        The oVirt external network provider for OVN
License:        GPLv2+
BuildArch:      noarch
URL:            https://gerrit.ovirt.org/#/admin/projects/ovirt-provider-ovn
#Source0:        %{name}-%{version}_0.tar.gz
Source0:        %{name}-%{version}.tar.gz

Requires: firewalld-filesystem
Requires: kernel >= 3.10.0-512
Requires: openvswitch-ovn-central >= 2.6
Requires: python-openvswitch >= 2.6

BuildRequires: python
BuildRequires: systemd

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT
%make_install


%description
The oVirt external network provider for OVN allows to integrate oVirt with the
Open vSwitch Open Virtual Network (OVN) solution. OVN is a Software Defined
Networking extension to Open vSwitch. OVN is integrated into oVirt using the
external network API. The oVirt provider for OVN serves as a proxy between
oVirt engine and OVN northd.

%post
%systemd_post ovirt-provider-ovn.service


%preun
%systemd_preun ovirt-provider-ovn.service


%postun
%systemd_postun_with_restart ovirt-provider-ovn.service


%package driver
Summary: The virtual interface driver for oVirt external network provider for OVN
License: GPLv2+
BuildArch: noarch
Requires: firewalld-filesystem
Requires: kernel >= 3.10.0-512
Requires: openvswitch >= 2.6
Requires: openvswitch-ovn-host >= 2.6
Requires: python-openvswitch  >= 2.6
Requires: vdsm
Requires(post): firewalld-filesystem


%description driver
The virtual interface driver for oVirt external network provider for OVN.
The driver handles the connection of NICs provisioned on oVirt hosts to OVN.


%files
%config(noreplace) %{_sysconfdir}/ovirt-provider-ovn
%config(noreplace) %{_sysconfdir}/ovirt-provider-ovn/logger.conf
%config(noreplace) %{_sysconfdir}/ovirt-provider-ovn/ovirt-provider-ovn.conf
%{_datadir}/ovirt-provider-ovn
%{_datadir}/ovirt-provider-ovn/*
%{_unitdir}/ovirt-provider-ovn.service
/usr/lib/firewalld/services/ovirt-provider-ovn.xml
/usr/lib/firewalld/services/ovirt-provider-ovn-central.xml

%files driver
%{_libexecdir}/vdsm/hooks/before_nic_hotplug/*
%{_libexecdir}/vdsm/hooks/before_device_create/*
%{_libexecdir}/ovirt-provider-ovn
%{_libexecdir}/ovirt-provider-ovn/setup_ovn_controller.sh
# TODO use %{python_sitelib} here and in `make install`
/usr/lib/python2.7/site-packages/vdsm/tool/ovn_config.py*


%changelog
* Mon Feb  27 2016 Marcin Mirecki
- open firewalld holes for OVN databases.