'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/scrollbar.n,v 1.10 93/04/01 09:52:54 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS scrollbar tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scrollbar \- Create and manipulate scrollbar widgets
.SH SYNOPSIS
\fBscrollbar\fI pathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveForeground\fR	\fBcursor\fR	\fBrelief\fR
.VE
\fBbackground\fR	\fBforeground\fR	\fBrepeatDelay\fR
\fBborderWidth\fR	\fBorient\fR	\fBrepeatInterval\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke to change the view
in the widget associated with the scrollbar.  When a user requests
a view change by manipulating the scrollbar, a Tcl command is
invoked.  The actual command consists of this option followed by
a space and a number.  The number indicates the logical unit that
should appear at the top of the associated window.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired narrow dimension of the scrollbar window,
not including 3-D border, if any.  For vertical
scrollbars this will be the width and for horizontal scrollbars
this will be the height.
.VS
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBscrollbar\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a scrollbar widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the scrollbar such as its colors, orientation,
and relief.  The \fBscrollbar\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A scrollbar is a widget that displays two arrows, one at each end of
the scrollbar, and a \fIslider\fR in the middle portion of the
scrollbar.  A scrollbar is used to provide information about what
is visible in an \fIassociated window\fR that displays an object
of some sort (such as a file being edited or a drawing).
The position and size of the slider indicate which portion of the
object is visible in the associated window.  For example, if the
slider in a vertical scrollbar covers the top third of the area
between the two arrows, it means that the associated window displays
the top third of its object.
.PP
Scrollbars can be used to adjust the view in the associated window
by clicking or dragging with the mouse.  See the BINDINGS section
below for details.

.SH "WIDGET COMMAND"
.PP
The \fBscrollbar\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrollbar widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscrollbar\fR
command.
.TP
\fIpathName \fBget\fR
Returns a Tcl list containing four decimal values, which are
the current \fItotalUnits\fR, \fIwidnowUnits\fR, \fIfirstUnit\fR,
and \fIlastUnit\fR values for the scrollbar.  These are the values
from the most recent \fBset\fR widget command on the scrollbar.
.TP
\fIpathName \fBset\fR \fItotalUnits windowUnits firstUnit lastUnit\fR
This command is invoked to give the scrollbar information about the
widget associated with the scrollbar.  \fITotalUnits\fR is an integer
value giving the total size of the object being displayed in the
associated widget.  The meaning of one unit depends on the associated
widget;  for example, in a text editor widget units might
correspond to lines of
text.  \fIWindowUnits\fR indicates the total number of units that
can fit in the associated window at one time.  \fIFirstUnit\fR
and \fIlastUnit\fR give the indices of the first and last units
currently visible in the associated window (zero corresponds to the
first unit of the object).  This command should
be invoked by the associated widget whenever its object or window
changes size and whenever it changes the view in its window.

.SH BINDINGS
.PP
The description below assumes a vertically-oriented scrollbar.
For a horizontally-oriented scrollbar replace the words ``up'', ``down'',
``top'', and ``bottom'' with ``left'', ``right'', ``left'',
and ``right'', respectively
.PP
A scrollbar widget is divided into five distinct areas.  From top
to bottom, they are:  the top arrow, the top gap (the empty space
between the arrow and the slider), the slider, the bottom gap,
and the bottom arrow.  Pressing mouse button 1 in each area has
a different effect:
.TP 20
\fBtop arrow\fR
Causes the view in the associated window to shift up by one unit
(i.e. the object appears to move down one unit in its window).
If the button is held down the action will auto-repeat.
.TP 20
\fBtop gap\fR
Causes the view in the associated window to shift up by one
less than the number of units in the window
(i.e. the portion of the object that used to appear at the very
top of the window will now appear at the very bottom).
If the button is held down the action will auto-repeat.
.TP 20
\fBslider\fR
Pressing button 1 in this area has no immediate effect except to
cause the slider to appear sunken rather than raised.  However,
if the mouse is moved with the button down then the slider will
be dragged, adjusting the view as the mouse is moved.
.TP 20
\fBbottom gap\fR
Causes the view in the associated window to shift down by one
less than the number of units in the window
(i.e. the portion of the object that used to appear at the very
bottom of the window will now appear at the very top).
If the button is held down the action will auto-repeat.
.TP 20
\fBbottom arrow\fR
Causes the view in the associated window to shift down by one unit
(i.e. the object appears to move up one unit in its window).
If the button is held down the action will auto-repeat.
.PP
Note:  none of the actions described above has an immediate impact
on the position of the slider in the scrollbar.  It simply invokes
the command specified in the \fBcommand\fR option to notify the
associated widget that a change in view is desired.  If the view is
actually changed then the associated widget must invoke the
scrollbar's \fBset\fR widget command to change what is displayed in
the scrollbar.

.SH KEYWORDS
scrollbar, widget
