#include <asm/system.h>
#include <cnix/head.h>
#include <cnix/mm.h>
#include <asm/bitops.h>
#include <string.h>      /* memset */



#define NR_FREE_LIST 10
#define isPageReserved(addr)  test_bit(PageReserved,addr)

#define invalidate() \
__asm__("movl %%eax, %%cr3"::"a"((unsigned long)kp_dir))


extern int KP_DIR_SIZE;
mem_map_t *mem_map = NULL;  /* the address of page discriptor array */

unsigned long free_area_init(unsigned long start_mem ,unsigned long end_mem);
void __free_pages(unsigned long addr ,int order);
void free_one_page(unsigned long addr);
unsigned long get_free_pages(unsigned long flags, int order);

/*
 * setup physical memory , start_mem is the end of data , end_mem is the last
 * byte of the total memory 
 */
unsigned long paging_init(unsigned long start_mem,unsigned long end_mem)
{

	int index,i;
	unsigned long * pg_table, *pg_dir;
	unsigned long addr;

	pg_dir = (unsigned long *)kp_dir;
	start_mem = PAGE_ALIGN(start_mem);
	addr = 0x800000 ; /* the first 8M is initialed in head.S */

	index = 2;
	
	while(addr < end_mem){
		pg_dir[index++] = start_mem | 7; /* present , r/w ,user */
		pg_table = (unsigned long *)start_mem ;
		for(i = 0;(i < FRAME_PER_PAGE) && (addr < end_mem);i++){
			pg_table[i] = addr | 7;
			addr += PAGE_SIZE;
		}
		start_mem += PAGE_SIZE;
	}
	KP_DIR_SIZE = index;
#if 1
	printk("The KP_DIR_SIZE is %d, index is %d\n",KP_DIR_SIZE,index);
	printk("the address in paging_init is 0X%x\n",addr);
	if(addr == end_mem )
		printk("correct in paging_init\n");
	else 
		printk("addr != end_mem\n");
#endif
	for(;index < 1024;index++)
		pg_dir[index] = 0;
	invalidate();
	return free_area_init(start_mem,end_mem);
}
	
struct free_area {
		struct page *next;
		struct page *prev;
		int *map;     /* the bitmap of memory's buddy system */
		int count;
};

struct free_area free_area_list[NR_FREE_LIST];
#define LONG_ALIGN(x)	((x) + sizeof(long) - 1)&~((sizeof(long)) - 1)

unsigned long free_area_init(unsigned long start_mem ,unsigned long end_mem)
{
	mem_map_t *p ;
	struct free_area *area;
	int map_nr,order;

	mem_map = (mem_map_t *)start_mem;
	map_nr =  MAP_NR(end_mem) ;   /* the total of page frame */
	p = mem_map + map_nr;
	memset((char *)(mem_map),0,(long)(p) - (long)mem_map);
	start_mem = LONG_ALIGN((unsigned long)p); 

	do{
		--p;
		p -> flags = (1 << PageReserved) | (1 << PageDMA);
		p -> count = 0;
	}while(p > mem_map);

/* 
 * now start_mem will point to the address of bitmap
 */
	
	for(area=free_area_list,order = 0;\
					area < &(free_area_list[NR_FREE_LIST]); area++,order++){
		int bitlength;
		bitlength = end_mem >> (PAGE_SHIFT + order+1);
		bitlength = (bitlength + 7) >> 3;
#if 0
		printk("order: %d bitlength: %d \n",order,bitlength);
#endif		
		area -> map =(int *)start_mem;
		memset((char *)(area->map),0,bitlength);
		area -> next = area -> prev = (struct page *)area;
		start_mem += bitlength;
		start_mem = LONG_ALIGN(start_mem);
	}
		
	printk("There are %d pages \n",map_nr);
	return start_mem;
}

/* #define get_free_page() 	get_free_pages(0,0) */

unsigned long get_one_page()
{
	unsigned long addr;

	if(!(addr = get_free_pages(0,0))) return NULL;
	memset((char *)addr,0,PAGE_SIZE);
	return addr;
}
						

/*
 * order is the power of 2
 * flags is to DMA, now I do not take into account DMA frame
 */
unsigned long get_free_pages(unsigned long flags, int order)
{
	int new_order;
	unsigned long size,map_nr;
	struct free_area *area;
	struct page  *ret ,*prev;
	
	area = &(free_area_list[order]);
	new_order = order;
		
	do{
		ret = area -> next;
		prev = ret -> prev;
		/*
		 * free_area[order] has free page to allocate
		 */
		if(ret != (struct page *)area)
			break;
		area++;
		new_order++;
	} while(new_order < NR_FREE_LIST);
		
	/* 
	 * now we don't implement page swap
	 */
	if(new_order == NR_FREE_LIST){
		printk ("Not Enough Free Pages ,Giving up .....\n");
		return NULL;
	}
	/* 
	 * we must take page from  much bigger block
	 */
		size = 1 << new_order;
		area -> next = ret -> next;
		ret -> next -> prev = (struct page *)area;
		map_nr = ret - mem_map;
		/* mark it that this block is being used */
		change_bit(map_nr >>(new_order+1),area->map);
	
	while(new_order > order){
		area--;
		new_order--;
		size >>= 1;
		/* insert into more smaller list */
		ret -> next = area -> next;
		ret -> prev = (struct page *)area;
		ret -> next -> prev = ret;
		area -> next = ret;
		area -> count++;
		map_nr = ret - mem_map;
		change_bit(map_nr >> (1 + new_order),area->map);
		ret += size; /* take the back half of the block */
		map_nr += size;
	}
	ret -> count = 1;
	return (map_nr<<PAGE_SHIFT);
}

void free_one_page(unsigned long addr)
{
	unsigned long map_nr;
	struct page *pg;
		
	map_nr = MAP_NR(_pa(addr));
	pg  = &(mem_map[map_nr]);

	if(pg -> count <= 0){
		panic("Trying to free FREE page %d ....",map_nr);
	}
	/* reserved page can not be freed */
	if(isPageReserved(&pg -> flags))
		return;
	
	if(--(pg->count) == 0)
		__free_pages(addr,0);
}
/*
 * The size which is to be freed is 2**order 
 */
void __free_pages(unsigned long addr ,int order)
{

	struct page *prev,*next;
	struct free_area *area;
	unsigned long map_nr,mask;
	unsigned long index;
	
	mask = ~((1UL << order) - 1);
	map_nr = MAP_NR(_pa(addr));
	map_nr &= mask;
	area = &(free_area_list[order]);
	index = map_nr >> (order + 1);

	while(mask + (1<<(NR_FREE_LIST - 1))){
				/* the buddy sytem is not free */
		if(!test_and_change_bit(index,area->map)){
			break;
		}
				/* remove the buddy system from the free_area_list*/
		prev = mem_map[map_nr ^ -mask].prev; /* get buddy page point*/
		next = mem_map[map_nr ^ -mask].next;
		area -> next = next;
		next -> prev = (struct page *)area;
		area -> count--;
		/* check the large block*/
		mask <<= 1;
		map_nr &= mask;
		index >>= 1;
		area++;
	}
				
	/* insert into correct pos */
	mem_map[map_nr].next = area -> next;
	mem_map[map_nr].prev = (struct page *)area;
	area -> next -> prev = &(mem_map[map_nr]);
	area -> next = &(mem_map[map_nr]);
	area -> count++;
}
void show_area()
{
	struct free_area *area;
	struct page *pg;
	int order,i;

	for (area = free_area_list,order =0;area < &(free_area_list[NR_FREE_LIST]);area++,order++){
			printk("area order: %d ,area count: %d\n",order,area->count);
			pg = area->prev;
			if(pg != (struct page *)area)
				  printk("The first addr:0x%x\n",((pg - mem_map)<<PAGE_SHIFT));
	}
				 
						   
}
