#include <const.h>
#include <asm/system.h>
#include <cnix/mm.h>

/* #define KP_DIR_SIZE (HIGH_MEM / (PAGE_SIZE * 1024)) */

extern unsigned long start_mem;
extern unsigned long end_mem;
extern mem_map_t *mem_map;
extern unsigned long kp_dir;
extern unsigned long get_one_page();
extern void free_one_page();

int KP_DIR_SIZE;

/*
 * I think when one process to do exit, it must release all pages it takes,
 * and then it's page dir, then it's pcb. 
 * from is page dir, and size is how many items in page dir. what's in %cr3 now
 * I think, it's kp_dir.
 */
int free_page_tables(unsigned long from, int size)
{
	unsigned long * pg_table, *pg_dir, nr;

	if(from & 0xfff)
		panic("in free_page_tables, error not alignment\n");
	
	if(from == kp_dir)
		panic("in free_page_tables, trying to free kernel page dir\n");
	
	pg_dir = (unsigned long *)from;
	
	for(; size-- > 0; pg_dir++){
		if(!(*pg_dir & 1))
			continue;

		/* if it's kernel page dir item */
		if((((unsigned long)pg_dir & (PAGE_SIZE - 1)) / 4) 
				< KP_DIR_SIZE){
			*pg_dir = 0;
			continue;
		}
	

		
		nr = 1024;
		pg_table = (unsigned long *)*pg_dir;
		for(; nr-- > 0; pg_table++){
			if(*pg_table & 1)
				free_one_page(*pg_table & 0xfffff000);
			*pg_table = 0;
		}
		
		/* sometimes I think it's not necessary to & ... */
		free_one_page(*pg_dir & 0xfffff000);

		*pg_dir = 0;
	}		

	return 0;
}

int copy_page_tables(unsigned long from, unsigned long to, int size)
{
	int nr;
	unsigned long * from_dir, * to_dir;
	unsigned long * from_pg_table, * to_pg_table, this_pg;
	
	if(from & 0xfff || to & 0xfff)
		panic("in copy_page_tables, address not alignment\n");

	from_dir = (unsigned long *)from;
	to_dir = (unsigned long *)to;

	for(; size-- > 0; from_dir++, to_dir++){
		if(*to_dir)
			panic("in copy_page_tables, \
				page dir item already exist\n"); 

		if(!(*from_dir & 1))
				continue;

		/* if it's kernel page dir item, skip next ... */
		if((((unsigned long)from_dir & (PAGE_SIZE - 1)) / 4) 
				< KP_DIR_SIZE){
			*to_dir = *from_dir;
			continue;
		}

		from_pg_table = (unsigned long *)(*from_dir & 0xfffff000);

		if(!(to_pg_table = (unsigned long *)get_one_page()))
				return -1;
		*to_dir = (unsigned long)to_pg_table | 7;	

		nr = 1024;
		for(; nr-- > 0; from_pg_table++, to_pg_table++){
			this_pg = *from_pg_table;
			if(!(this_pg & 1))
				continue;
			
			/* could not be given out, I think this condition 
			 * doesn't exist.
			 */
			if(this_pg < start_mem)
				panic("in copy_page_tables, can't happen.");
			
			/* copy on write, now write page_fault. */
			this_pg &= ~2;
			*from_pg_table = this_pg;
			*to_pg_table = this_pg;

/*			this_pg = (this_pg - LOW_MEM) >> 12; */
			/* need to lock ???, will be decrement in ??? */
/*			mem_map[(this_pg >> PAGE_SHIFT)].count++; */
			mem_map[MAP_NR(this_pg)].count++;
		}
	}

	return 0;
}

