#include <cnix/mm.h>

struct page_descriptor {
	struct page_descriptor *pd_next;
	struct block_header *pd_firstfree;
	int  pd_order;
	int  pd_nfrees;
	};

struct block_header {
	unsigned long  bh_flags;
	struct block_header *bh_next;
};

struct sizes_descriptor {
	struct page_descriptor *sd_firstfree;
	struct page_descriptor *sd_dmafree;
	int     sd_nblocks;
	int 	sd_npages;         /* how many pages dose this bucket has */
	int	sd_nfrees;	/* how many free blocks in this bucket */
	unsigned long sd_gfporder;
};

/* the blocksize = (PAGE_SIZE - sizeof(page_descriptor))/number */
const unsigned int blocksize[]={
	32,
	64,
	128,
	255,
	510,
	1020,
	2040,
	4096-16,
	8192-16,
	16384-16,
	32768 - 16,
	65536 - 16,
	131072 - 16,
	0
	};
struct sizes_descriptor sizes[]={
		{NULL,NULL,127,0,0,0},
		{NULL,NULL,63,0,0,0},
		{NULL,NULL,31,0,0,0},
		{NULL,NULL,16,0,0,0},
		{NULL,NULL,8,0,0,0},
		{NULL,NULL,4,0,0,0},
		{NULL,NULL,2,0,0,0},
		{NULL,NULL,1,0,0,0},
		{NULL,NULL,1,0,0,1},
		{NULL,NULL,1,0,0,2},
		{NULL,NULL,1,0,0,3},
		{NULL,NULL,1,0,0,4},
		{NULL,NULL,1,0,0,5},
		{NULL,NULL,0,0,0,0}
};	

extern unsigned long get_free_pages(unsigned long flags,int order);
extern void __free_pages(unsigned long addr,int gfporder);


#define BLOCKSIZE(order)     (blocksize[order])
#define MFREE		0xAA55AA55UL

char * kmalloc(int size,int flags)
{
	struct page_descriptor *pg;
	struct sizes_descriptor *bucket;
	struct block_header *bh;
	int order;
	char *p;
	
	
	bucket = sizes;
	order = 0;
	
	for(;;){
		if((size <= BLOCKSIZE(order)) || !BLOCKSIZE(order))
			break;
	bucket++;
	order++;
	}

	if(!BLOCKSIZE(order)){
			printk("The size you request is too large for cnix\n");
			return NULL;
	}

	if(bucket->sd_firstfree == NULL){ /* has no free blocks ,allocate */
			unsigned long addr;
			struct block_header * tmp;
			int i;

			if((addr = get_free_pages(0,bucket->sd_gfporder)) == NULL){
					printk("Not enough %d continous pages",bucket->sd_gfporder);
					return NULL;
			}

			/* initial the bucket and the page_descriptor */
			pg = (struct page_descriptor *)addr;

			pg->pd_next = bucket->sd_firstfree;
			bucket->sd_firstfree = pg;
			bucket->sd_npages++;
			pg->pd_nfrees = bucket->sd_nblocks;
			bucket->sd_nfrees += pg->pd_nfrees;
			pg->pd_order = order;
			/* 16 = sizeof(struct page_descriptor) */
			pg->pd_firstfree = (struct block_header *)(addr + 16);

			addr += 16;
			tmp = (struct block_header *) addr;
			/* add the free blocks to the list */
			for(i = 0;i < (bucket->sd_nblocks - 1);i++){
					addr += BLOCKSIZE(order); /*move to next block*/
					tmp->bh_flags = MFREE;
					tmp->bh_next = (struct block_header *)(addr);
					tmp = tmp->bh_next;
			}
			/* the last one */
			tmp->bh_flags = MFREE;
			tmp->bh_next = NULL;
	}

	pg = bucket->sd_firstfree;
#if 1
	if(pg->pd_nfrees == 0){
			printk("The free list of %d order has no free blocks,impossible\n");
 			return NULL;
	}
#endif	
	bh=pg->pd_firstfree;
	if(bh->bh_flags != MFREE){
			printk("Error , block_header list in page is not free !\n");
			printk("this page pd_nfrees: %d \n",pg->pd_nfrees);
			panic("");
	}
	pg->pd_firstfree = bh->bh_next;
	pg->pd_nfrees--;
	/* update the sizes_descriptor */
	bucket->sd_nfrees--;

	p = (char *)bh;

	return p;
}

#define PAGE_DESC(x) ((struct page_descriptor *)((unsigned long)x & PAGE_MASK))

void kfree(char *p)
{
		struct page_descriptor *pg;
		struct block_header *bh;
		struct sizes_descriptor *bucket;
		int order;

		pg =  PAGE_DESC(p);

		/* add the free block to the free list in page */
		bh = (struct block_header *)p;
		bh->bh_next = pg->pd_firstfree;
		pg->pd_firstfree = bh;

		bh->bh_flags = MFREE;  /* mark it unused */

		order = pg->pd_order;
		bucket = &(sizes[order]);
		/* upate the page_desc and sizes_desc */
		pg->pd_nfrees++;
		bucket->sd_nfrees++;

		if(pg->pd_nfrees == bucket->sd_nblocks){ /* all free */
				struct page_descriptor *tmp;
				struct page_descriptor *prev;
				
				prev = tmp = bucket->sd_firstfree;

				if(pg == tmp)
						bucket->sd_firstfree = pg->pd_next;
				else{
						while(tmp != pg && tmp){
								prev = tmp;
								tmp = tmp->pd_next;
						}
				}

				if(!tmp){
						panic("something error in order %d in kfree\n",order);
				}
				
				/* delete it from the free list */
				prev->pd_next = pg->pd_next;
				/* update the size_desc */
				bucket->sd_npages--;
				bucket->sd_nfrees -= bucket->sd_nblocks;

				/* free the 2^sd_gfporder pages */
				__free_pages((unsigned long)pg,bucket->sd_gfporder);

		}
				
}	
	
					
