#include <unistd.h>
#include <const.h>
#include <stdarg.h>
#include <asm/io.h>
#include <asm/regs.h>
#include <asm/system.h>
#include <cnix/sched.h>
#include <cnix/cfile.h>
#include <string.h>

int volatile count = 0;
int volatile flag = 0; 
long volatile timer_count = 0;
int volatile sflag = 0;
unsigned long start_mem,end_mem;

extern void vga_init(void);
extern void intr_init(void);
extern void traps_init(void);
extern void timer_init(void);
extern void ide_init(void);
extern void buf_init(void);
extern void fs_init(void);
extern void sched_init(void);
extern void sleep_on(struct wait_queue **p);
extern void wake_up(struct wait_queue **p); 
extern void reboot(void);
extern void get_mem(unsigned long *,unsigned long *);
extern unsigned long paging_init(unsigned long ,unsigned long);
extern void mem_init(unsigned long , unsigned long);
extern void show_area();
extern unsigned long get_free_pages(int,int);
extern char *kmalloc(int size,int flags);
extern void kfree(char *p);

/* floppy */
extern void floppy_init();
extern void floppy_test();

int errno;	
_syscall0(int, fork)

static void init(void);

int main(void)		
{	
	/* Note!!! traps_init and intr_init must be executed first. */
	traps_init();
	intr_init();

	/* Now it's ok to enable interrupt. */
	sti();	
	
	vga_init();
	puts("Cnix beta version!\n");
	get_mem(&start_mem,&end_mem);
	printk("The system memory is %d M\n",(end_mem>>20));
	start_mem = paging_init(start_mem,end_mem);
	mem_init(start_mem,end_mem);
/*	show_area();  */
	buf_init();
	timer_init();
	/* I think ide will  use delay function which will be supported by 
	 * timer, so after being laid timer_init.
	 */
	ide_init();
	sched_init();
 	fs_init();   

	/* floppy init */
	floppy_init();
	puts("floppy driver init!!\n");

	if(!fork()){
		init();
	}	

	while(1);
}

static void init()
{
	int i;
	unsigned char c;
	unsigned char buff[20];
	/* PAGE_SIZE is the size of the stack of user stack */
	/* _syscall2(int, exec, fn_t, func, int, size) */
	/* exec(shell, PAGE_SIZE); */
	
	for(;;){
		printk("\n[cnix@ 51.net]# ");
		i = 0;
		c = getchar();
		while(c != '\n' && i < 20){
			printk("%c", c);
			buff[i++] = c;
			c = getchar();
		}

		buff[i] = '\0';
		printk("\n");
		if(c == '\n'){
				int order;
		        if(!strcmp(buff, "malloc")){
	        	      char *p;
			          p =  kmalloc(64,0);
					  if(!p){
							  printk("No memory!\n");
					  }else{
							  /* s trcpy(p,"ABCD"); */
						   char *tmp="ABCDEFFFFFFFFFFFFFFFGGGGGGGGGGGGG";
						   {
								   int j = 0;
								   while (j < 62)
										   p[j++] = 'C';
								   p[j] = '\0';
						   }
						   printk("The p is %x\n",p);
						   for(i = 0;i < 61;i++)
								   putchar(p[i]);
						   kfree(p);  
					  }
				}
					 

		        if(!strcmp(buff, "readme"))
		                read_file("readme");
			
				switch(parse_options(buff,&order)){
						case 1:/* get free pages */
								get_free_pages(0,order);
								show_area();
								break;
						case 2:
							 	break;
						default:
								break;
				}

			/* added by sunwen */
			if(!strcmp(buff,"floppy"))
			  floppy_test();

			if(!strcmp(buff, "cnix"))
				printk("Welcome!");
			else if(!strcmp(buff, "reboot"))
				reboot();
			

			continue;
		}

		printk("%s", buff);
	}
}
/*for test ,and delete it some days later*/

read_file(char *filename)
{

      int size;
      struct cfile *file_test;
      
      file_test = cnix_open("cnix",filename);
      
      printk("\n%s\n",file_test->file_buf);
}
/* somt macro is used below */
#define isdigit(x)  ((x) <= '9' && (x) >= '0')
#define todigit(x)  ((x) - '0')
/* 
 * parse command number , if ret value is 0 ,then The input is error 
 * else is rigth , if no digit input , the order is 0
 */
int parse_options(char *buf,int *retp)
{
		int number,ch;
		char *p;

		p = buf;
		number = 0;

		while((ch = *p++) && (ch != ' ' ));
		*--p ='\0';
/*
 * get free page 
 */
		if(!strcmp(buf,"gfp") || !strcmp(buf,"fbp")){
				/* remove the space */
				while((ch = *++p) == ' '|| ch == '\t' ) ;
				
				while(isdigit(*p)){
				number += todigit(*p) + number*10; 			
				p++;
				}
		}
		*retp = number;
		if(!strcmp(buf,"gfp")) return 1;
		if(!strcmp(buf,"fbp")) return 2;

		return 0; /* some errors */

}
				






