#ifndef MM_H
#define MM_H

#define  PAGE_SIZE  (1UL<<PAGE_SHIFT)
#define  PAGE_SHIFT 12
#define  PAGE_MASK  (~(PAGE_SIZE - 1))
#define  FRAME_PER_PAGE 1024
#define  PAGE_ALIGN(addr) ((((unsigned long)(addr)) + PAGE_SIZE - 1) & PAGE_MASK)
#define  MAP_NR(addr)	  (((unsigned long)(addr)) >> PAGE_SHIFT)
#define  _pa(addr)		  ((unsigned long)addr)

#ifndef NULL
#define NULL (unsigned long)0
#endif

#define PageReserved 	1
#define PageDMA			2


typedef struct page{
	struct page * prev;
	struct page * next;
	int count;
	unsigned long flags;
}mem_map_t;

extern mem_map_t *mem_map;

#endif
