#include <cnix/fs.h>

#define FROM_40K  (10*0x1000)     /* the data of buf start here FROM_40K */
#define lock() __asm__("cli"::)
#define unlock() __asm__("sti"::)

static struct buf_head bfreelist; /* the buf head of free list */
static struct buf_head *hash_table[NR_HASH];

 /* The free list is empty ,proc has buf must sleep and wait for it */
static struct task_struct *buf_wait ;

static struct buf_head buf[NR_BUF];

static struct buf_head *getblk(int dev,int block);
static struct buf_head *get_hash_table(int ,int );
static void   put_hash_table(struct buf_head *);
static void   notavail(struct buf_head *);
static void   iowait(struct buf_head *);

//extern void ll_rw_block(int , struct buf_head *);
extern void sleep_on(struct task_struct **);
extern void wakeup(struct task_struct **);
extern int printk(const char *fmt,  ...);
extern int panic (const char *fmt,  ...);

void brelse(struct buf_head *);

ll_rw_block(int block, struct buf_head * buf)
{

}


void buf_init() /* only run once at startup */
{
	int i;
	register struct buf_head *bh;

	bfreelist.b_next_free = bfreelist.b_prev_free = bfreelist.b_next
		= bfreelist.b_prev = &bfreelist;

	for (i = 0 ; i < NR_BUF; i++){
		bh = &buf[i];
		lock();
		bh -> b_next = bfreelist.b_next;
		bh -> b_prev = &bfreelist;
		bfreelist.b_next -> b_prev = bh;
		bfreelist.b_next = bh;

		bh -> b_flags |= B_BUSY;
		brelse(bh);   /* add  to free list */
		unlock();
/* start from 40k */
		bh -> b_data = (unsigned char *)(FROM_40K + i* BLOCKSIZ);
		bh -> b_dev = NODEV;
		bh -> b_blocknr = 0;
	}
	for (i = 0; i < NR_HASH; i++)
		hash_table[i] = NULL;
	printk("Buffer number : %d Hash number : %d\n",NR_BUF,NR_HASH);
}

struct buf_head *bread(int dev,int block)
{
	struct buf_head *bh;

	if ((bh = getblk(dev,block)) == NULL)
		panic("getblk failed!\n");

	if ( bh -> b_flags & B_DONE ) {/* the data is same to disk */
		bh -> b_flags |= B_BUSY; /*  mark this buf has been used */
		return bh;
	} 

	/* we must read from disk */
	ll_rw_block(READ,bh);
	iowait(bh);
	if ( bh -> b_flags & B_ERROR){ /* when read has some error*/
		brelse(bh);
		return (NULL);
	}
	return (bh);
}

/* return a LOCKED buf */
static struct buf_head * getblk(int dev,int block)
{
	struct buf_head *tmp;
/* 
 *  NOTE!! because we implement asyn write , in hard disk interrupt we could 
 *   change the b_flags ; We must lock when we test b_flags
 */
loop:
	if((tmp = get_hash_table(dev,block))){ /* the buf is in hash table */
		lock();
		if ( tmp -> b_flags & B_BUSY) {
/* mark it another proc want to use it */
			tmp -> b_flags |= B_WANTED;
			sleep_on(&tmp->b_wait); 
			unlock();
			goto loop;
		}
		unlock();
/* This buf is not avail */
		notavail(tmp);
		return  (tmp);
	}

	lock();
/* there is no free list , sleep */
	if ( bfreelist.b_next_free == &bfreelist){
		bfreelist.b_flags |= B_WANTED;
		sleep_on(&buf_wait);
		unlock();
		goto loop;
	}
	unlock();
/* remove from free list and put it into new hash table */
	notavail(tmp = bfreelist.b_next_free);
/* because disk interrupt do not change B_DELWRI ,We need not lock it */
	if ( tmp -> b_flags & B_DELWRI ){ 
		tmp -> b_flags |= B_ASY ; /* asychronize   write */
		bwrite(tmp);
		goto loop;
	}


	tmp -> b_dev = dev;
	tmp -> b_blocknr = block;
	tmp -> b_flags = (B_BUSY|B_READ);

	put_hash_table(tmp);

	return (tmp);
	   	
}

/* write bh -> b_data to disk , asy or syn */
void bwrite(struct buf_head *bh)
{
	register struct buf_head *rbh;
	int flags;

	rbh = bh;
	flags = rbh -> b_flags;

	rbh -> b_flags &= ~(B_READ|B_ERROR|B_DELWRI);
	ll_rw_block(WRITE,rbh);

	if ((flags & B_ASY) == 0){ /* sync ,we must wait */
		iowait(rbh);     
		brelse(rbh);
	}
/* i can not determine it */
/* else if (flags & B_DELWRI) {
   brelse(rbh);
   return;
   }  
*/
}

/* wait for an i/o completation */
static void iowait(struct buf_head *bh)
{
	lock();
	while(!(bh -> b_flags & B_DONE))
		sleep_on(&bh->b_wait);
	unlock();
}

/* free a B_BUSY buf ,and add it to the tail of free list */
void brelse (struct buf_head *bh)
{

	if (bh -> b_flags & B_WANTED) /* some proc wait for this buf */
		wakeup(&bh->b_wait);
	if(bfreelist.b_flags & B_WANTED) /* some proc wait for freelist */
		wakeup(&buf_wait);

	lock();
	bh -> b_flags &= ~(B_WANTED|B_BUSY|B_ASY);
/* put bh at the tail of free list */
	bh -> b_next_free = &bfreelist;
	bh -> b_prev_free = bfreelist.b_prev_free;
	bfreelist.b_prev_free->b_next_free = bh;
	bfreelist.b_prev_free = bh;
	unlock();
}

#define hashfn(dev,block) hash_table[(block^dev)%NR_HASH]
static struct buf_head * get_hash_table(int dev,int blocknr)
{
	struct buf_head * bh;
	struct buf_head *hash;

	hash = hashfn(dev,blocknr);
	if (!hash) /* (dev ,blocknr) not in hash table */
		return (NULL);
/*
  bh = hash -> b_next;
  do {
  if((bh -> b_dev == dev) && (bh -> b_blocknr == blocknr))
  break;
  bh = bh -> b_next;
  } while(bh != hash );
*/
	if ( (hash -> b_dev == dev) && (bh -> b_blocknr == blocknr))
		return hash;
	for ( bh = hash -> b_next; bh != hash ; bh = bh -> b_next)
		if ( (bh -> b_dev == dev) && (bh -> b_blocknr == blocknr))
			break;
	if ( bh != hash ) 
		return bh;
	else
		return (NULL);

}


static void put_hash_table(struct buf_head *bh)
{
	struct buf_head *hash;

	hash = hashfn( bh -> b_dev, bh -> b_blocknr);

	if ( !hash ){
		hashfn(bh -> b_dev, bh -> b_blocknr) = bh;
		bh -> b_next = bh -> b_prev = bh;
		
	} else {
/* put at the head of hash table */
		bh -> b_next = hash -> b_next;
		bh -> b_prev = hash ;
		hash -> b_next -> b_prev = bh;
		hash -> b_next = bh;
	}

}

/* set B_BUSY flags and remove buffer head from free list */
static void notavail(struct buf_head *bh)
{
	lock();
	bh -> b_flags |= B_BUSY;

	bh -> b_next_free -> b_prev_free = bh -> b_prev_free;
	bh -> b_prev_free -> b_next_free = bh -> b_next_free;

	unlock();
}


/* 
 * iodone is used in hard disk interrupt to indicate that an i/o operation 
 * has competed , And put it at the free list  if it is an asynchronize 
 * write or read 
*/
void iodone(struct buf_head *bh)
{

	bh -> b_flags |= B_DONE;

	if ( bh -> b_flags & B_ASY){
		brelse(bh);
	} else {
		bh -> b_flags &= ~B_WANTED ;
		wakeup(&bh->b_wait);
	}
}


/* add some test */
