#include <asm/io.h>
#include <cnix/ide.h> 
#include <cnix/partition.h>


#define ide_io_read(port,buf,nr) \
__asm__("cld;rep;insw"::"d" (port),"D" (buf),"c" (nr))

#define ide_io_write(port,buf,nr) \
__asm__("cld;rep;outsw"::"d" (port),"S" (buf),"c" (nr))

extern long volatile timer_count;

delay_50ms()
{
      int time_delay;
      
      time_delay = timer_count;
      while((timer_count - time_delay ) < 6);
}

delay_s(int section)
{	
	int i;
	for(i=0;i<20 *section;i++)
		delay_50ms();
}

ide_stutas_ok()
{
      while(inb(HD_STATUS) & BUSY_STAT){
	    delay_50ms();
	    
      }
}

#define READ_CMD 0x20

lba_read_sector(long sector,unsigned char *buf)
{
        int c,h,s;

       
	s = sector &0xff;
	c = (sector &0xffff00)>>8;
	h = (sector &0xf000000)>>24;

     	outb(1,HD_NSECTOR);

	outb(s,HD_SECTOR);
	outb(c,HD_LCYL);
	outb(c>>8,HD_HCYL);
	/*the master disk*/
	outb(0xE0|(0<<4)|h,HD_CURRENT);
	outb(READ_CMD,HD_COMMAND);

	ide_stutas_ok();
	ide_io_read(HD_DATA,buf,256);
}


ide_chs_read(int c,int h,int s,unsigned char *buf)
{
	/* the new ide have not the attrib
	outb(_WPCOM,HD_ERROR);
	*/
        /*READ sector data,the asmcos default=1*/
	outb(1,HD_NSECTOR);

	outb(s,HD_SECTOR);
	outb(c,HD_LCYL);
	outb(c>>8,HD_HCYL);
	/*the master disk*/
	outb(0xA0|(0<<4)|h,HD_CURRENT);
	outb(READ_CMD,HD_COMMAND);

	ide_stutas_ok();
	ide_io_read(HD_DATA,buf,256);

}

get_ide_info()
{
        int status;
        hd_driveid id; 
      
        unsigned short *ver_add;
	unsigned char *disk_add;
	unsigned int  cyl;
	unsigned char  head;
	unsigned int  sect;
	unsigned int ver_cs,ver_offset,ver_line;

        outb(0xa0,HD_CURRENT);
        outb(0xec,HD_STATUS);
      
        while(inb(HD_STATUS)&0x80);
	
	ide_io_read(HD_DATA,&id,256);
	/*bios C/H/S */
	ver_add = 0x104;
	ver_offset = ver_add[0];
	ver_cs = ver_add[1];
	ver_line= ver_cs*0x10 + ver_offset;
	disk_add = ver_line; 
	
	cyl =  (disk_add[1]<<8)+disk_add[0];
	head = disk_add[2];
	sect = disk_add[14];
	/*lba mode*/
        cyl = id.lba_capacity /(head*sect) ;
	printk("Your disk C:%d,H:%d,S:%d,LBA:%d\n",cyl,head,sect,id.lba_capacity);
}

struct partition *ext2_part;
int ext2_true ;
unsigned char ext2_buf[512];

get_partition()
{
        struct partition *part;
	
	ext2_true = 0;

	lba_read_sector(0,ext2_buf);
	
        
       	part = &ext2_buf[0x1be];
	print_part(part);
	find_ext_part(part);
	
	part = &ext2_buf[0x1be +16]; 
        print_part(part);
	find_ext_part(part);	

	part = &ext2_buf[0x1be +32];
	print_part(part);
	find_ext_part(part);

	part = &ext2_buf[0x1be +48];
	print_part(part);
	find_ext_part(part);
}

#define DOS_EXT   0x5
#define CHS_EXT   0xf
#define LINUX_EXT 0x85
#define EXT2_PART 0x83

int find_ext_part(struct partition *part)
{
         unsigned char buf[512];
         struct partition *ext_part;
	 
	 switch(part->sys_ind)
	   {
	   case DOS_EXT:
	   case CHS_EXT:
	   case LINUX_EXT:
		       
	     lba_read_sector(part->start_sect ,buf);
		
	     break;

	   case EXT2_PART:
	     if(ext2_true==0)
	       {ext2_part = part; ext2_true =1;}
	     return 0;

	   default:
	        return 0;
	        
	   }
	 
	 ext_part = &buf[0x1be];
	 print_part(ext_part);

	 ext_part = &buf[0x1be +16];
	 print_part(ext_part);

}


const char *
get_sysname(unsigned char type) {
       struct systypes *s;

       for (s = sys_types; s->type<0xff; s++)
            if (s->type == type)
	          return s->name;
       return "Unknown,wait you add";
}


int part_count=1;
print_part(struct partition *part)
{
         int enable;
	 int i;

	 char *part_type;

	 if (part->sys_ind ==0) return;

	 part_type = get_sysname(part->sys_ind);

	 enable = (part->boot_ind &0x80)>>1;
/*	 printk("Filesystem type ID:%s\n",part_type);
	 printk("Size :%d!Mb\n\n",part->nr_sects/2048); */
}

ide_init()
{
	get_ide_info();
}
