#include <asm/io.h>
#include <fdreg.h>
#include <asm/system.h>
#include <fd.h>
#include <dma.h>

#define SECTOR_SHIFT 9

#define REALLY_SLOW_IO
#define FLOPPY_IRQ 6
#define FLOPPY_DMA 2
#define MAX_ERRORS 12
#define SECTOR_SIZE 512

static void seek();
static void wait_int();
static void setup_DMA();
static void NEC_output(unsigned char outn);
static void result();
static void is_busy();
static void recalibrate_floppy();
static void wait_time();
static void floppy_int();
static void send_read_command();

static void read_sector();

struct request
{
  unsigned char head;
  unsigned char sector;
  unsigned char track;
  char buffer[2*SECTOR_SIZE];
};

struct request current_request;/* the request para ,used by users*/

static struct floppy_struct floppy = {
	 2880,18,2,80,0,0x1B,0x00,0xCF,0x6C,"1.44M"	  /* 1.44MB diskette */
};

/* the NEC controller DOR command */
/* unsigned char NEC_command=0; */

unsigned char current_DOR=0;/* output register */

int running=0; /* motor is running? 0:no 1:yes*/

int busy=0; /* is fdc busy? 0:no 1:yes */

int recalibrate=1;/* need recalibrate? 1:need 0;no */

int int_status=0;/* interrupt occured? 0:no 1:yes */

int dma_command=FD_READ;
/*
 * globals used by 'result()'
 */
#define MAX_REPLIES 7
static unsigned char reply_buffer[MAX_REPLIES];
#define ST0 (reply_buffer[0])
#define ST1 (reply_buffer[1])
#define ST2 (reply_buffer[2])
#define ST3 (reply_buffer[3])

/* only 1.44MB diskette ! */
/* ------------------------------------------------------------------- */

char teststr[20];
/* ___________________________________________________________________*/

static void NEC_output(unsigned char outn)
{
  outb(FD_DOR,outn);
}
  
static void motor_on()
{
  unsigned char dor=28; /* turn bit 2,3,4 on */
  if(running)
    return;
  
  /* select drive A and turn the 1st motor on */
  outb(dor,FD_DOR);
  running =1;
}

static void motor_off()
{
  unsigned char dor=12; /* turn bit 4 off */
  outb(dor,FD_DOR);
  running=0;
}
  
static void is_busy()
{
  unsigned char status;
  status=inb(FD_STATUS);
  if(status & 128)
    {
      busy=1;
    }
  else{
    busy=0;
  }
  return;
}

static void wait_int()
{
  /* test */
  puts("enter wait_int\n");

  for(;;)
    {
      if(int_status==1)
	break;
    }

  int_status=0;

  /* test */
  puts("leave wait_int\n");

  return;
}

static void result()
{
  int i;
  for(i=0;i<7;i++)
    reply_buffer[i]=inb(FD_DATA);

  return;
}


static void setup_DMA()
{  
  long addr=current_request.buffer;
  cli();
  disable_dma(FLOPPY_DMA);
  clear_dma_ff(FLOPPY_DMA);
  set_dma_mode(FLOPPY_DMA, (dma_command == FD_READ)? DMA_MODE_READ : DMA_MODE_WRITE);
  set_dma_addr(FLOPPY_DMA, addr);
  set_dma_count(FLOPPY_DMA,SECTOR_SIZE);
  enable_dma(FLOPPY_DMA);
  sti();
}

static void read_sector()
{
  sti();
  motor_on();
  wait_time(); // wait motor to speed up 
  seek(); // seek the track 
  wait_int(); // wait the floppy int and see seek is success 
  wait_time(); // wait the head stick 
  setup_DMA(); // setup up the DMA 
  send_read_command(); 
  wait_int(); // wait until the read command executing 
  result(); // fetch the result 
  motor_off();
  
}

static void recalibrate_floppy()
{
	recalibrate = 0;
	NEC_output(FD_RECALIBRATE); /* send recalibrate command */
	NEC_output(0); /* select driver A */
}

static void seek()
{
  /* seek the track */
  NEC_output(FD_SEEK);
  NEC_output(current_request.track);

  /* test */
  puts("is seek\n");
}

static void wait_time()
{
  int i;
  for(i=0;i<10000000;i++)
    {
    }
}

static void send_read_command()
{
  NEC_output(FD_READ);
  NEC_output(0); /* head,track */
  NEC_output(current_request.track);
  NEC_output(current_request.head);
  NEC_output(current_request.sector);
  NEC_output(2); /* bytes per sector. 0:128b 1:256b 2:512b 3:1024b */
  NEC_output(floppy.sect); /* EOT */
  NEC_output(floppy.gap); /* GPL */
  NEC_output(0xFF);

  /* test */
  puts("is read\n");
}

void floppy_test()
{
	int i;
	if(int_status==0)
	  {
	    puts("int_status==0!!\n");
	  }
	
	current_request.track=3;
	current_request.head=0;
	current_request.sector=2;
	
	/* if(int_status==1)
	  {
	    puts("floppy int handled!!\n");
	  }else
	    {
	      puts("floppy int not handled!!\n");
	    }
	*/
	dma_command=FD_READ;
	read_sector();
	puts("reply 1:\n");
	puts("reply 2:\n");
	puts("reply 3:\n");
}

void floppy_init()
{
  put_irq_handler(FLOPPY_IRQ,floppy_int);
}

void floppy_int()
{
  int_status=1;
  return;
}









