#include <asm/bitops.h>
#include <cnix/head.h>
#include <cnix/mm.h>
#include <cnix/kernel.h>

/*
 * get the physical memory info
 */
void get_mem(unsigned long *start_memp,unsigned long *end_memp)
{
	unsigned long end_mem;
	unsigned long tmp;
	end_mem = 1UL<<20;
	tmp = (*(unsigned short *)(0x7c00 + 2)); /* this is the extend memory */
	/* ... */
	end_mem = (end_mem + (tmp << 10)) & 0xfffff000;
	*end_memp = end_mem;
	*start_memp = (unsigned long)&end;
#if 1	
	printk("02 value 0x%x\n",((*(unsigned  short *)(0x7c00 + 2))));
	printk("end_mem 0x%x\n",end_mem);
#endif	
}

/* 
 * add all free pages to free_area_list 
 * and caculate the Reserved page number
 */
void mem_init(unsigned long start_mem,unsigned long end_mem)
{
	int ncodepages,ndatapages,nreservedpages,nmem_map_and_bitmap;
	int nfreepages = 0;
	unsigned long addr;
	struct page *pg;

	ncodepages = ndatapages = nreservedpages = nmem_map_and_bitmap = 0;
	addr = 0;
	start_mem = PAGE_ALIGN(start_mem);
	end_mem = (end_mem)& PAGE_MASK;

	while(addr < start_mem){
		if((addr >= 0x100000) && (addr < (unsigned long)&etext))
			ncodepages++;
		else if((addr >= (unsigned long)&etext) \
						&& (addr < (unsigned long)&end))
			ndatapages++;
		else if(addr >= (unsigned long)&end)
			nmem_map_and_bitmap++;
		nreservedpages++;
		addr += PAGE_SIZE;
	}
	while(addr < end_mem){
		pg = &mem_map[(addr>>PAGE_SHIFT)];
		if(addr > 0x1000000) /* address < 16M , is the region of dma using */
			clear_bit(PageDMA,&pg->flags);
		clear_bit(PageReserved,&pg->flags);
		pg -> count = 1;
		free_one_page(addr);
		nfreepages++;
		addr += PAGE_SIZE;
	}

#if 1	
	printk("page start at 0x%x\n", start_mem);
	printk("Reserved Pages:%d\n",nreservedpages);
	printk("Code  Pages:%d\n",ncodepages);
	printk("Data  Pages:%d\n",ndatapages);
	printk("mem_map and bitmap  Pages:%d\n",nmem_map_and_bitmap);
	printk("Free  Pages:%d\n",nfreepages);
#endif	
}	
		
