#ifndef SCHED_H
#define SCHED_H

#include <const.h>
#include <signal.h>
#include <cnix/types.h>
#include <cnix/head.h>
#include <cnix/wait.h>
#include <cnix/file.h>

#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_ZOMBIE		3
#define TASK_STOPPED		4

#define TSS_ENTRY		5

struct i387_struct{
	long	cwd;
	long	swd;
	long	twd;
	long	fip;
	long	fcs;
	long	foo;
	long	fos;
	long	st_space[20];
};

struct tss_struct{
	long	linkage;
	long	esp0;
	long	ss0;
	long	esp1;
	long	ss1;
	long	esp2;
	long	ss2;
	long	cr3;
	long	eip;
	long	eflags;
	long	eax;
	long	ecx;
	long	edx;
	long	ebx;
	long	esp;
	long	ebp;
	long	esi;
	long	edi;
	long	es;
	long	cs;
	long	ss;
	long	ds;
	long	fs;
	long	gs;
	long	ldt;
	unsigned short trace, bitmap;
	/* Now I still have some questions about it, so not to use it. */
	/* struct i387_struct i387; */
};

struct task_struct{
	int	need_sched;

	long	state;
	unsigned long pg_dir;	
	
	unsigned long esp;
	unsigned long eip;

	struct task_struct * prev;
	struct task_struct * next;	/* linked in run queue */

	long	priority;
	long	counter; 

	unsigned long	end_code, end_data, start_stack;

	unsigned long	signal;
	unsigned long	blocked;
	struct sigaction sigaction[SIGNR];	/* will be sigaction. */
	
	struct file_desc file[FILE_DESC_NUM];

	int	exit_code;

	long	pid, ppid; /* pgrp, session, leader; */
	int	tty;

	int child_num;
	int exit_child_pid;
	struct wait_queue * wait_for_child;
	/* 
	unsigned short uid, euid, suid;
	unsigned short gid, egid, sgid;
	long	alarm;
	long	utime, stime, cutime, cstime, start_time;
	unsigned short used_math;
	struct desc_struct ldt[2]; 
	*/
};

union task_union{
	struct task_struct task;
	char	stack[PAGE_SIZE];
};

#define ltr(n) __asm__("ltr %%ax"::"a"((unsigned long)n << 3))

#define switch_to(prev, next) do{\
__asm__ volatile("pushl %%ebx\n\t"\
	"pushl %%ecx\n\t"\
	"pushl %%esi\n\t"\
	"pushl %%edi\n\t"\
	"pushl %%ebp\n\t"\
	"pushl %%fs\n\t"\
	"movl %%esp, %0\n\t"\
	"movl %2, %%esp\n\t"\
	"movl $1f, %1\n\t"\
	"pushl %3\n\t"\
	"jmp __switch_to\n\t"\
	"1:\n\t"\
	"popl %%fs\n\t"\
	"popl %%ebp\n\t"\
	"popl %%edi\n\t"\
	"popl %%esi\n\t"\
	"popl %%ecx\n\t"\
	"popl %%ebx\n\t"\
	:"=m"(prev->esp), "=m"(prev->eip)\
	:"m"(next->esp), "m"(next->eip), "a"(prev), "d"(next));\
}while(0)

#endif
