#ifndef KERNEL_H
#define KERNEL_H

#include <cnix/types.h>
#include <cnix/sched.h>

extern struct tss_struct tss;	
extern union task_union init_task;
extern struct task_struct * current;
extern struct task_struct * run_queue;
extern struct task_struct * task[NR_TASKS];

extern void add_run(struct task_struct *);
extern void del_run(struct task_struct *);
extern void sched_init(void);
extern void schedule(void);
extern void sleep_on(struct wait_queue **);
extern void wakeup(struct wait_queue **);

extern int printk(const char * fmt, ...);
extern int panic(const char * fmt, ...);

extern void intr_init(void);
extern int put_irq_handler(int, fn_t);

#endif
