#ifndef FS_H
#define FS_H

#include <cnix/buffer.h>
#include <cnix/super.h>
#include <cnix/file.h>
#include <cnix/dirent.h>

extern struct buf_head * getblk(int, int);
extern struct buf_head * bread(int ,int);
extern void brelse(struct buf_head *);
extern void bwrite(struct buf_head *);
extern void iodone(struct buf_head *);

extern void fs_init(void);
extern int open(char *, int);
extern int read(int, char *, int);
extern int write(int, char *, int);
extern int seek(int, int, int);
extern int close(int);
extern int unlink(char *);

#endif
