#ifndef FILE_H
#define FILE_H

#include <cnix/buffer.h>
#include <cnix/super.h>

#define FREE	0
#define USED	1

#define RDONLY	1
#define WRONLY	2
#define	RDWR	(RDONLY | WRONLY)
#define CREATE	4

#define SEEK_SET	0
#define SEEK_CUR	1
#define SEEK_END	2

#define DIRITEMSIZE	32
#define FNAME_BYTES	29

struct dir_item{
	unsigned char flag;	/* FREE OR USED */
	char fname[FNAME_BYTES];
	unsigned short inum;
};

struct inode{
	unsigned long attr;	/* Now used for flag of used or free */
	unsigned long dev;
	unsigned long ctime;
	unsigned long atime;
	unsigned long mtime;
	unsigned long fsize;
	unsigned short block[20];
};

struct filp{
	int filp_count;
	int filp_offset;
	struct inode * iptr;
};

#define FILE_DESC_NUM	32

struct file_desc{
	int flag;
	int mode;
	struct filp * flptr;
};

#endif
