#include <cnix/kernel.h>
#include <cnix/driver.h>

struct tty_struct ttys[TTY_NUM];
struct tty_struct * cur_tty;

extern void kbd_interrupt(void);

void tty_init(void)
{
	int i;

	for(i = 0; i < VGA_NUM; i++){
		vga_init(i);

		ttys[i].tq.head = ttys[i].tq.tail = 0;
		ttys[i].wait = (struct wait_queue *)0;
	}

	put_irq_handler(0x01, &kbd_interrupt);

	cur_tty = &ttys[0];
	select_vga(0);
}
