#include <errno.h>
#include <stdarg.h>
#include <asm/regs.h>
#include <cnix/driver.h>
#include <cnix/fs.h>
#include <cnix/kernel.h>

extern int find_empty_process(void);
extern int copy_process(int, struct regs_t);
extern int do_execve(char *, char **, char **, struct regs_t *);
extern int do_exit(int);
extern int do_wait(int *);

int sys_fork(struct regs_t regs)
{
	int i, ret;

	i = find_empty_process();
	if(i < 0)
		return i;
	
	ret = copy_process(i, regs);

	if(ret < 0)
		return ret;

	return i;
}

int sys_execve(struct regs_t regs)
{
	int ret;
	
	ret = do_execve((char *)regs.ebx, (char **)regs.ecx, (char **)regs.edx, &regs);

	return ret;
}

int sys_wait(int * status)
{
	int ret;

	ret = do_wait(status);

	return ret;
}

int sys_exit(int exitcode)
{
	int ret;

	ret = do_exit(exitcode);

	return ret;
}

int sys_printf(const char * string)
{
	puts((char *)string);

	return 0;
}

unsigned long sys_getchar(void)
{
	unsigned char c;

	c = readchar();

	return c;
}

int sys_open(char * filename, int mode)
{
	int ret;

	ret = open(filename, mode);

	return ret;
}

int sys_close(int fd)
{
	int ret;

	ret = close(fd);

	return ret;
}

int sys_read(int fd, char * buffer, int size)
{
	int ret;

	ret = read(fd, buffer, size);

	return ret;
}

int sys_seek(int fd, int offset, int mode)
{
	int ret;

	ret = seek(fd, offset, mode);

	return ret;
}

int sys_write(int fd, char * buffer, int size)
{
	int ret;

	ret = write(fd, buffer, size);

	return ret;
}

int sys_unlink(char * filename)
{
	int ret;
	
	ret = unlink(filename);
	
	return ret;
}

void sys_null_call(void)
{
	printk("calling sys_null_call...\n");
}
