#include <unistd.h>
#include <const.h>
#include <stdarg.h>
#include <asm/io.h>
#include <asm/regs.h>
#include <asm/system.h>
#include <cnix/wait.h>
#include <cnix/driver.h>
#include <cnix/kernel.h>
#include <cnix/fs.h>

unsigned long start_mem,end_mem;

extern void tty_init(void);
extern void intr_init(void);
extern void traps_init(void);
extern void timer_init(void);
extern void ide_init(void);
extern void buf_init(void);
extern void fs_init(void);
extern void reboot(void);
extern void get_mem(unsigned long *,unsigned long *);
extern unsigned long paging_init(unsigned long ,unsigned long);
extern void mem_init(unsigned long , unsigned long);
extern void show_area();
extern unsigned long get_free_pages(int,int);
extern char *kmalloc(int size,int flags);
extern void kfree(char *p);

extern void floppy_init();
extern void floppy_test();

int errno;	
_syscall0(int, fork)
_syscall3(int, execve, char *, filename, char **, argv, char **, envp)

static void init(void);

int main(void)		
{	
	/* Note!!! traps_init and intr_init must be executed first. */
	traps_init();
	intr_init();

	/* Now it's ok to enable interrupt. */
	sti();	
	
	tty_init();
	
	puts("Cnix beta version!\n"); 

	get_mem(&start_mem,&end_mem);
	printk("The system memory is %d M\n",(end_mem>>20));
	start_mem = paging_init(start_mem,end_mem);
	mem_init(start_mem,end_mem);
//	show_area();

	buf_init();

	sched_init();

	timer_init();

	/* I think ide will  use delay function which will be supported by 
	 * timer, so after being laid timer_init.
	 */
	ide_init();

	printk("floppy driver init.\n");
	floppy_init();
	/*printk("floppy driver test.\n");
	floppy_test();*/

	fs_init();

	if(!fork()){
		init();
	}

	if(!fork()){
		open("tty1", 0);
		init();
	}	

	/* 
	 * because it's in kernel, so must to sched itself, because
	 * when timer interrupt happen, it will not to schedule ret_from_intr
	 */
	/* But I think idle could do some useful work, like get some info about
	 * system.
	 */
	while(1){ schedule(); }
}

static void init()
{
	printk("\n**************Welcome to CNIX!***************\n");
	execve("shell", (char **)NULL, (char **)NULL);
	
	while(1);
}
