#ifndef PAGE_H
#define PAGE_H

#include <const.h>

#define  PAGE_MASK  (~(PAGE_SIZE - 1))
#define  FRAME_PER_PAGE 1024
#define  PAGE_ALIGN(addr) ((((unsigned long)(addr)) + PAGE_SIZE - 1) & PAGE_MASK)
#define  MAP_NR(addr)	  (((unsigned long)(addr)) >> PAGE_SHIFT)
#define  _pa(addr)		  ((unsigned long)addr)

#ifndef NULL
#define NULL (unsigned long)0
#endif

#define PageReserved 	1
#define PageDMA		2


typedef struct page{
	struct page * prev;
	struct page * next;
	unsigned long flags;
	int count;
}mem_map_t;

#endif
