#ifndef DRIVER_H
#define DRIVER_H

#include <cnix/buffer.h>
#include <cnix/tty.h>
#include <cnix/vga.h>
#include <cnix/dma.h>
#include <cnix/fd.h>
#include <cnix/fdreg.h>
#include <cnix/ide.h>
#include <cnix/timer.h>

extern struct vga_struct vgas[];

extern void vga_init(int);
extern void select_vga(int);
extern void puts(char *);
extern unsigned char readchar(void);

extern void do_tty_interrupt(void);

extern void ide_init(void);
extern int ll_rw_block(int, struct buf_head *);

extern void m_start(struct m_state * ms);
extern unsigned int m_elapsed(struct m_state * ms);
extern void m_delay(unsigned int msec);

#endif
