#include <asm/regs.h>
#include <asm/system.h>
#include <cnix/head.h>

extern void divide_err(void);
extern void debug(void);
extern void nmi(void);
extern void int3(void);
extern void overflow(void);
extern void bounds(void);
extern void invalid_op(void);
extern void device_not_avl(void);
extern void double_fault(void);
extern void coprocessor_segment_overrun(void);
extern void invalid_tss(void);
extern void segment_not_present(void);
extern void stack_segment(void);
extern void general_protection(void);
extern void page_fault(void);
extern void coprocessor_fault(void);
extern void system_call(void);

static void reserved(void)
{
	panic("error: idt is reserved.\n");
}

void traps_init(void)
{
	int index;
	
	set_trap_gate(0, divide_err);
	set_trap_gate(1, debug);
	set_trap_gate(2, nmi);
	/* ...... */
	set_trap_gate(3, int3);
	set_trap_gate(4, overflow);
	set_trap_gate(5, bounds);

	set_trap_gate(6, invalid_op);
	set_trap_gate(7, device_not_avl);
	set_trap_gate(8, double_fault);
	set_trap_gate(9, coprocessor_segment_overrun);
	set_trap_gate(10, invalid_tss);
	set_trap_gate(11, segment_not_present);
	set_trap_gate(12, stack_segment);
	set_trap_gate(13, general_protection);
	set_trap_gate(14, page_fault);
	set_trap_gate(15, coprocessor_fault);

	for(index = 16; index < 32; index++)
		set_trap_gate(index, reserved);
	
	/* when call, does it auto-cli */
	set_system_gate(0x80, &system_call);	
}

void do_test_intr(void)
{

	printk("intr \n");
}

int sched_stop ;

void do_with_exception(struct regs_t regs)
{
	sched_stop = 1;

	if(regs.es == 14)
		panic ("page_fault\n");

	printk ("\nCNIX system exception = %d err_code = %x \n
		eax: 0x%08x eip: 0x%08x esp: 0x%08x ebp: 0x%08x
		ebx: 0x%08x ecx: 0x%08x edx: 0x%08x edi: 0x%08x
		 ds: 0x%08x  es: 0x%08x cs:  0x%08x  ss: 0x%08x\n", 
			regs.es, regs.index,
			regs.eax,regs.eip,regs.esp,regs.ebp,
			regs.ebx,regs.ecx,regs.edx,regs.edi,
			regs.ds, regs.es, regs.cs,regs.ss);
	panic ("system auto stop");
}
