#ifndef MM_H
#define MM_H

#include <const.h>

#define  PAGE_MASK  (~(PAGE_SIZE - 1))
#define  FRAME_PER_PAGE 1024
#define  PAGE_ALIGN(addr) ((((unsigned long)(addr)) + PAGE_SIZE - 1) & PAGE_MASK)
#define  PAGE_NR(addr)	  (((unsigned long)(addr)) >> PAGE_SHIFT)
#define  _pa(addr)		  ((unsigned long)addr)

#ifndef NULL
#define NULL (unsigned long)0
#endif

#define PageReserved 	1
#define PageDMA		2


typedef struct page{
	struct page * prev;
	struct page * next;
	unsigned long flags;
	int count;
}mem_map_t;

extern mem_map_t *mem_map;

extern unsigned long get_one_page();
extern void free_one_page(unsigned long addr);
extern int copy_page_tables(unsigned long from, unsigned long to, int size);
extern int free_page_tables(unsigned long from, int size);
#endif
