/*--------------------------------------------------
 *the ext2 filesystem read for cnix write by 2002-06
 *modification at 2003-01-18
 *--------------------------------------------------
 */

#include <cnix/ext2_fs.h>
#include <cnix/partition.h>
#include <string.h>
#include <cnix/config.h>

#define ROOT_INODE      2

extern void lba_read_sector(long sector,unsigned char *buf);
extern void get_partition(void);

extern struct disk_partition part_p[8]; 
struct partition *ext2_part;

struct cnix_ext2 cn_e2;
struct ext2_inode root_inode;
struct ext2_inode current_inode;

/*init the open file table */
void init_open_file(void)
{
       int fd;

       for(fd = 0;fd<OPEN_MAX;fd++)
	 open_file[fd].open_flag = 0;
       init_namei();
}


/*-------------------------
 * get ext2 in part_p[8]
 * return 1 = ok
 *-------------------------
*/
static int part_count;
int 
get_ext2_part(struct partition **ext2_part)
{
	int i;

	if (HDA >0){
	      *ext2_part = &part_p[HDA-1].part;
	      part_count = HDA;
	      return 1;
	}
	/*if HDA = AUTO_HDA */
	 
	for(i = 1;i < 8; i++){
	    if (part_p[ i-1 ].part.sys_ind == 0x83){
	         *ext2_part = &part_p[ i-1 ].part;
		 part_count = i;
		 return 1;
	    }  
	}
	return 0;
	
}

/*-------------------------------
 * get super block save data
 * 
 *-------------------------------
*/

int 
read_super()
{
        unsigned char buf[512];
        struct ext2_super_block *e2sb;
	int block_size;

	if(!get_ext2_part(&ext2_part)){
	     printk("You config auto search ext2 system,but cann't find hda%d!\n",HDA);
	     panic ("sorry!");
	}

	if(ext2_part->sys_ind != 0x83) {
	     printk("You config the hda%d is not ext2 filesystem!\n",part_count);
	     panic ("sorry!");
	}
	
	/*first sector is boot block ,so 2nd sector is super!*/
       	
	lba_read_sector(ext2_part->start_sect +2,buf); 
	
	e2sb = (struct ext2_super_block *)buf;

	if(e2sb->s_magic == EXT2_SUPER_MAGIC )
	        printk("Find ext2 super block ok!\n");
	else { printk("Can't find ext2 super block!\n"); return 0;}

	/*fix by asmcos,thank xiexiecn*/
	block_size = 1<<e2sb->s_log_block_size ;

	/*save the super block data to cnix ext2 for user*/
	cn_e2.s_blocks_per_group = e2sb->s_blocks_per_group;
	cn_e2.s_inodes_per_group = e2sb->s_inodes_per_group;
	cn_e2.s_inode_size       = e2sb->s_inode_size;
	
	cn_e2.block_size         = block_size * 2;
	cn_e2.s_inodes_per_block = cn_e2.block_size * 512 /
		                          sizeof(struct ext2_inode);
	cn_e2.start_sect         = ext2_part->start_sect;
	cn_e2.s_desc_per_block	 = cn_e2.block_size * 512 / 
					sizeof (struct ext2_group_desc); /* =32*/
	cn_e2.s_itb_per_group    = cn_e2.s_inodes_per_group /
	                                        cn_e2.s_inodes_per_block;
	if(block_size == 2 ) cn_e2.gd_first_block     = 2;
	else cn_e2.gd_first_block = 1;

	/*group describe table
	* the boot and super block in 0 block
	* the group describe table in 1 block
	* the block size = n k(n = 1,2,4), = 2n sectors.
	* cn_e2.block_size is sectors data.
	*/
	
	read_inode(ROOT_INODE,&root_inode);
	memcpy (&current_inode,&root_inode,sizeof(struct ext2_inode));
	printk("Mount hda%d is ok!\n",part_count);
	init_open_file();
	
}


void
fs_init(void)
{
        get_partition();
	read_super();
}
