#include <string.h>

#include <cnix/ext2_fs.h>
#include <cnix/cfile.h>

extern struct cnix_ext2 cn_e2;
extern struct ext2_inode current_inode;

struct file open_file[OPEN_MAX];

long inode_add ;

int sys_open(const char * filename,int flag,int mode)
{
	struct ext2_inode * inode;
	int i,fd;
	
	for(fd=0 ; fd<OPEN_MAX ; fd++)
		if (!open_file[fd].open_flag)
			break;
	
	if (fd>=OPEN_MAX)
		return -1;
	open_file[fd].open_flag = 1;
	
	
	if ((i=open_namei(filename,flag,mode,&inode)) == 0) {
	        open_file[fd].open_flag = 0;
		return -1;
	}
	
	open_file[fd].f_mode  = inode->i_mode;
	open_file[fd].f_flags = flag;
	open_file[fd].f_inode = inode;
	return (fd);
}

/*-----------------------------
 *return -1 failed,and 1 is ok
 *
 * ---------------------------
 * */

int sys_cd(char *dirname)
{
	struct ext2_inode * inode;
	
	
	if(dir_open_namei(dirname,&inode) == 0){
	
		return -1;
	}	

	memcpy(&current_inode, inode,sizeof(struct ext2_inode));

	
	return 1;

}

/*-------------------------
 * return -1 is failed,and 
 * 1 is ok!
 * 
 *
 *-------------------------
 * */
int sys_ls()
{
	int i;

	unsigned char * block_buf;

	block_buf = (unsigned char *) malloc(cn_e2.block_size * 512);
	
	
	for(i=0;i < current_inode.i_blocks ; i++ )
	{
	
		/*read 12 block,need modify*/
		if(i > 11 ) return -1;
		bread ( current_inode.i_block[i] , block_buf);
		if( list_dir (block_buf) ) return 1;
	
	}
	
}

/*----------------------
 * return 1 ,dir end
 *
 * ---------------------
 * */

int list_dir(char * block_buf)
{

      struct ext2_dir_entry_2 *temp_dir;
      unsigned char *dir_buf;
      int i ,j;
      unsigned char dirname[256];
      unsigned char *filetype = "[file]   ";
      unsigned char *dirtype  = "[dir]    ";
      unsigned char *unknown  = "[unknown]";
      unsigned char *typestring ;
      
      dir_buf = block_buf;
      i = cn_e2.block_size * 512;
      
      while ( i > 0 ){ 
	     temp_dir = (struct ext2_dir_entry_2 *)dir_buf;
	     
	     if (temp_dir -> rec_len == 0) return 1;
	     
	     for(j = 0; j<temp_dir->name_len; j++)
	     	dirname[j] = temp_dir->name[j];
	     dirname[temp_dir->name_len] = '\0';
	     
	     
	     if(temp_dir->file_type == 1 ) typestring = filetype;
	     else if(temp_dir->file_type == 2 ) typestring = dirtype;
	     else typestring = unknown;
	     
	     printk("%s",typestring );
	     printk(" %s \n",dirname);
	     dir_buf = dir_buf + temp_dir->rec_len;
	     i = i - temp_dir->rec_len;
      }

}

int sys_close(unsigned int fd)
{	


	if (fd >= OPEN_MAX)
		return -1;

	open_file[fd].open_flag = 0;
	
	/*free open_file[fd].f_inode */
	return (0);
}
