#include <cnix/ext2_fs.h>
#include <string.h>

/*from linux 0. 01 include/asm/segment.h*/

extern struct cnix_ext2  cn_e2;
extern struct ext2_inode root_inode;
extern struct ext2_inode current_inode;

unsigned char child_dirname[256];/*to test MAX_FILENAME LEN = 256*/
struct ext2_dir_entry_2 *child_dir ={0,} ;

extern char *malloc(int size);
/*-----------------------------
 *from buf get child_dirname 's
 * dir entry,return 0 =success,
 * 1 =failed
 *-----------------------------
 */

int 
find_dir(unsigned char *buf)
{
      struct ext2_dir_entry_2 *temp_dir;
      unsigned char *dir_buf;
      int i ;

      dir_buf = buf;
      i = cn_e2.block_size * 512;

      
      while ( i > 0 ){ 
	     temp_dir = (struct ext2_dir_entry_2 *)dir_buf;
	     
	     if (temp_dir -> rec_len == 0) break;

	
	     if(child_dirname[temp_dir->name_len] != '\0') goto continue_find;
	     //     printk("file name %d , %s\n",temp_dir->name_len, temp_dir->name);
	     if(strncmp (child_dirname, temp_dir->name,temp_dir->name_len) == 0 ){
		
		   
		     memcpy(child_dir, temp_dir,temp_dir->rec_len);
		     
		 	return 0;
	     }
	     
continue_find: 
	     dir_buf = dir_buf + temp_dir->rec_len;
	     i = i - temp_dir->rec_len;
      }
      return 1;
}

/*--------------------------------
 *get child dir for file 's inode
 *for parent dir's inode,and 
 *parent's inode have know!
 *return 1 is success,0 is failed
 *________________________________
 */
struct ext2_inode *parent_inode = {0,};
struct ext2_inode *child_inode  = {0,};

/*
get_child_inode(struct ext2_inode * parent,
		char * child_dirname,const struct ext2_inode * child)
*/
static
int
get_child_inode()
{
      unsigned char *buf;
      int ret,i = 0;

      buf = (unsigned char *)malloc(cn_e2.block_size * 512);

      
      
      bread(parent_inode->i_block[i++],buf);
      
      while(find_dir(buf)){
	   
	    bread(parent_inode->i_block[i++],buf);
	    /*I  think about the EXT2_NDIR_BLOCKS*/
	    if(i>parent_inode->i_blocks || i > 12) return 0;
      }
      
      ret = read_inode (child_dir->inode,child_inode);
     
      return ret; 
	      
}
/*------------------------------
 * child_dirname is child file
 * return i is file length
 *
 *------------------------------
*/
static unsigned char *open_filename;

static 
int 
get_dir_name ()
{
     char c;
     int i=0;
     
     /* cnix default open file name from root
      * "/usr/cnix/readme", 
      * "/home/asmcos/cnix/fs/Makefile"
      */
     //while(c=get_fs_byte(open_filename++)){
     while( (c = open_filename [0]) != 0x00){
	     
       open_filename ++;
       if(c!='/')
	 child_dirname[i++] = c;
       else break;
       
     }
     child_dirname[i]='\0';
     return i;
}
/*-------------------------------------------
 *return 1 is success,0 is failed
 *
 * ------------------------------------------
 * */
int 
open_namei(char *filename,short flag,short mode,const struct ext2_inode **inode)
{
      struct ext2_inode * ret_inode;
      
      /*if the pwd is exist parent_inode = root_inode,need modified*/
      open_filename = filename;
     
     if(open_filename[0] == '/'){ 
      	  memcpy(parent_inode,&root_inode,sizeof(struct ext2_inode));
      /*parent_inode = root so filename[0] = '/';  */
      	  open_filename++;
     } else{
      	  
	  memcpy(parent_inode,&current_inode,sizeof(struct ext2_inode));
     }
      while(get_dir_name()){
//	printk("get dir name %s,\n",&child_dirname);	
	if(get_child_inode()){
	      memcpy(parent_inode,child_inode,sizeof(struct ext2_inode));
	}else return 0;
      }

      ret_inode = (struct ext2_inode *) malloc(sizeof(struct ext2_inode));
      memcpy(ret_inode ,child_inode,sizeof(struct ext2_inode));
      *inode = ret_inode;
      return 1;
}

int
dir_open_namei(char *filename,const struct ext2_inode **inode)
{
	
      struct ext2_inode * ret_inode;
      
      /*if the pwd is exist parent_inode = root_inode,need modified*/
      open_filename = filename;
      
      if( open_filename[0] == '/' ) {
	      memcpy(&current_inode,&root_inode,sizeof(struct ext2_inode));
      	      open_filename++;
      }
      
      memcpy(parent_inode,&current_inode,sizeof(struct ext2_inode));
      
      while(get_dir_name()){
	if(get_child_inode()){
		
		memcpy(parent_inode,child_inode,sizeof(struct ext2_inode));
	}else return 0;
      }

 
      ret_inode = (struct ext2_inode *) malloc(sizeof(struct ext2_inode));
      memcpy(ret_inode ,child_inode,sizeof(struct ext2_inode));
      *inode = ret_inode;
      return 1;
}


int 
init_namei(void)
{
      parent_inode = (struct ext2_inode *) malloc(sizeof(struct ext2_inode));
      child_inode  = (struct ext2_inode *) malloc(sizeof(struct ext2_inode));
      child_dir    = (struct ext2_dir_entry_2 *) malloc (sizeof (struct ext2_dir_entry_2));
}
