#include <cnix/fs.h>
#include <cnix/ext2_fs.h>
#include <string.h>

extern struct cnix_ext2 cn_e2;
struct ext2_dir_entry_2 current_dir[20];

extern char * malloc(int size);
extern void bread(unsigned long block,char *buf);

void get_block_group_d(unsigned long inode_group , struct ext2_group_desc *e2gd);
/*------------------------------------------------
 * from inode_count get inode info
 * return 1 is success , 0 is faild
 *------------------------------------------------
 */



int 
read_inode(unsigned long inode_count,struct ext2_inode *e2ino)
{
        unsigned long inode_group,inode_group_offset;
	unsigned long inode_group_block,inode_group_block_offset;
  
	struct ext2_group_desc *e2gd;
	unsigned char *e2ino_block_buf;
 
	e2gd = (struct ext2_group_desc *)malloc( sizeof(struct ext2_group_desc));
	/*inode_group = inode_count in N group*/
	inode_group        = inode_count / cn_e2.s_inodes_per_group;
	inode_group_offset = inode_count % cn_e2.s_inodes_per_group;
	
	if(inode_group_offset == 0)	
		inode_group_offset = cn_e2.s_inodes_per_group;
	
	
	get_block_group_d(inode_group,e2gd);

	inode_group_block        = inode_group_offset / cn_e2.s_inodes_per_block;
	inode_group_block_offset = inode_group_offset % cn_e2.s_inodes_per_block;
	if (inode_group_block_offset == 0) 
		inode_group_block_offset = cn_e2.s_inodes_per_block;

	
	e2ino_block_buf  = malloc(cn_e2.block_size * 512);
	bread(e2gd->bg_inode_table + inode_group_block , e2ino_block_buf);

	
	memcpy ( e2ino,e2ino_block_buf + (inode_group_block_offset-1) 
	       * cn_e2.s_inode_size,cn_e2.s_inode_size);

//	if (e2ino->i_flags == 1) return 0; /*file have been deleted*/
	
	return 1;
}

/*----------------------------------------------------
 *inode_group       : inode in the group
 *inode_group_offset: inode in the group's offset 
 *get the inode's group's describtor
 *----------------------------------------------------
*/

void 
get_block_group_d(unsigned long inode_group , struct ext2_group_desc *e2gd)
{
        unsigned char *buf;
	long block_count;
	long block_count_offset;
	
	buf = malloc(cn_e2.block_size * 512);
	
	inode_group = inode_group +1 ;

	block_count        = inode_group / cn_e2.s_desc_per_block;
	block_count_offset = inode_group % cn_e2.s_desc_per_block;
	if(block_count != 0 && block_count_offset == 0)
		block_count_offset = cn_e2.s_desc_per_block;
	
	bread(cn_e2.gd_first_block + block_count,buf);

	/*the 32 is group describtors size */
	memcpy (e2gd , buf+ (block_count_offset - 1) * 32,32 );
	
	
}

