#include <string.h>
#include <vga.h>
#include <tty.h>
#include <asm/io.h>
#include <asm/system.h>
#include <cnix/wait.h>

#define VGA_CRT_INX	0x3d4
#define VGA_CRT_DATA 	0x3d5

#define VID_MEM		0xb8000

#define LINES		25
#define COLS		80


extern void kbd_interrupt(void);

unsigned char *vidmem;
static int pos;
static int cursor_x,cursor_y;

struct tty_queue read_q = { 0,0,""} ;/* head ,tail ,buf */


struct wait_queue * wait;

static inline void gotoxy(unsigned int x, unsigned  int y);


static void scroll_up( void )
{

        /*copy for linux 0.0.1
	 *the scroll_up_1 dea,it form arch/i386/boot/compressxxx/misc.c
	 */
	int i;
        int j;
	int n;

	char *d = (char *)vidmem;
	char *s = (char *)(vidmem+COLS*2);
	

	n=( LINES - 1 ) * COLS * 2 ;
	for (j=0;j<n;j++) d[j] = s[j];
		
	for ( i = ( LINES - 1 ) * COLS * 2; i < LINES * COLS * 2; i += 2 )
		vidmem[i] = ' ';
}
#if 0

static void scroll_up_1()
{
	int i;
	unsigned char * vidptr;
	unsigned char sr_buf[80*24*2];

        cli();
	memcpy ( VID_MEM + cols * 2, VID_MEM + (cols * 2) * 2, ( lines - 2 ) * cols * 2 );
	
	sti();
	vidptr = (unsigned char *)(VID_MEM + (lines - 1) * cols * 2);
	for (i = 0; i < cols * 2; i += 2)
		vidptr[i] = ' ';
}
/*use the scroll up can be do computer dea why? for misc.c */
#endif
static inline void gotoxy(unsigned int x,unsigned int y)
{
	pos =( COLS * y +x) * 2;

	cli();
	outb(14, VGA_CRT_INX);
	outb(0xff & (pos >> 9), VGA_CRT_DATA);
	outb(15, VGA_CRT_INX);
	outb(0xff & (pos >> 1), VGA_CRT_DATA);
	sti();

	cursor_x = x;
	cursor_y = y;
}

void puts(char *s)
{
	unsigned char c;
	int x, y;

	x = cursor_x;
	y = cursor_y;

	while ( ( c = *s++ ) != '\0' ) {
		switch (c) {
		case '\n':
			x = 0;
			if ( ++y >= LINES ) { 
				scroll_up();
				y--;
			}
			break;
		case '\t':
			x += 8;
			if ( x >= COLS ) {
				x = 0;
				if ( ++y >= LINES ) { 
					scroll_up();
					y--;
				}
			}
			break;
		default:
			vidmem [ ( x + COLS * y ) * 2 ] = c; 
			if ( ++x >= COLS ) {
				x = 0;
				if ( ++y >= LINES ) {
					scroll_up();
					y--;
				}
			}
		}
	}
	cursor_x = x;
	cursor_y = y;
	gotoxy(x,y);
}

void putchar(char  c)
{
	int x,y;
	
	x = cursor_x;
	y = cursor_y;

	if (c == '\n') { /* print next line */
		x = 0;
		if ( ++y >= LINES ) {
			scroll_up();
			y--;
		}
	} else if (c == '\t') {
		x += 8;
		if ( x >= COLS ) {
			x = 0;
			if ( ++y >= LINES ) { 
				scroll_up();
				y--;
			}
		}
	} else {
		vidmem [ ( x + COLS * y ) * 2 ] = c; 
		if ( ++x >= COLS ) {
			x = 0;
			if ( ++y >= LINES ) {
				scroll_up();
				y--;
			}
		}
	}

	cursor_x = x;
	cursor_y = y;
	gotoxy(x,y);
}


void 
delchar(void)
{
	int x,y;
	
	x = cursor_x;
	y = cursor_y;
	
	if(x==0){
	    if (y==0);
	    else { x =80; y--;}
	}else x--;
        
	vidmem [ ( x + COLS * y ) * 2 ] = 0x20; 

	cursor_x = x;
	cursor_y = y;
	gotoxy(x,y);
}
static int input = 0;

unsigned char getchar(void)
{	
	unsigned char ch;

	if(read_q.tail == read_q.head){
//		sleep_on(&wait);		
	
		while(input == 0 ) {
			delay_50ms();
		}
		input = 0 ;
	}
	
	ch = read_q.buf[read_q.tail];
	read_q.tail = (read_q.tail + 1) & (SIZE - 1);

	return ch;
}

void do_tty_interrupt(int channel)
{
	if(read_q.tail != read_q.head)
//		if(wait != NULL)
//			wakeup(&wait);
		input = 1;
}

void vga_init()
{
	int x, y;
	unsigned char val;

	x = *(unsigned char *)(0x7c00+510);
	y = *(unsigned char *)(0x7c00+511);

	x = 0, y++;
	gotoxy(x,y);
	vidmem = (char *)VID_MEM;

	wait = NULL;

	put_irq_handler(0x1,&kbd_interrupt);
}
