/*
    yamm, Yet Another Micro Monitor
    wutmp.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/types.h>
#include <utmp.h>
#include <time.h>
#include <string.h>
#if defined(NCURSES)
# include "ncurses.h"
#else
# include <curses.h>
#endif /* NCURSES */
#include "define.h"
#include "extern.h"

/*
	This is a list of hosts that can connect to your machine.
	If the host don't match, a '*' is printed near the address.
	If you WANT disable this put NULL in first line. ( look at
	line 27 ).

	Ex: I have:
static char *allow_list[] = {
	"149.132",
	"0.0.0.0",
	NULL
};
*/

static char *allow_list[] = {
	NULL
};

static char allowed ( addr )
char *addr;
{
	register int i = 0;
	register char *host = NULL;

	if ( !allow_list [ 0 ] ) 
		return ( ' ' );

	for ( host = allow_list [ i ]; host; host = allow_list [ ++i ] )
		if ( !strncmp ( host, addr, strlen ( host )))
			return ( ' ' );
	
	return ( '*' );
}

void examine_utmp ()
{
	register int j;
	struct utmp *us;
	char buf [ 18 ]; /* problems in \0 */
	extern char *inet_ntoa();
	struct tm *mtime;

	setutent();

#ifndef NO_CURSES
#define PF (void)printw
#else
#define PF (void)printf
#endif


	PF("\nUSER       TTY           HOST                 FROM                TIME    D/M\n");

	for ( j = displayed = 0, us = getutent(); us ; us = getutent() ) {

	if ( us->ut_type != USER_PROCESS )
		continue;

	strncpy ( buf, us->ut_user, 8 );
	buf [ 8 ] = '\0';

	if ( look_uid != -1L && look_uid != get_user_id( buf ) ) 
		continue;

#ifndef NO_CURSES
	if ( j++ < pages*Num_display_proc )
		continue;
#endif


	if ( Num_display_proc >= 0 && displayed >= Num_display_proc )
		break;

	displayed++;

	PF( "%-8s", buf );

	strncpy ( buf, us->ut_line, 12 );
	buf [ 12 ] = '\0';
	PF( "   %-12s", buf);

	strncpy ( buf, us->ut_host, 16 );
	buf [ 16 ] = '\0';
	PF ("  %-16s   %c %-16s", buf,
		allowed ( inet_ntoa ( us->ut_addr )), inet_ntoa (us->ut_addr ));

	if ( ( mtime = localtime ( &us->ut_time ) ) != NULL ) 
		PF ("    %2d:%.2d  %2d:%.2d\n", 
			mtime->tm_hour,
			mtime->tm_min,
			mtime->tm_mday,
			mtime->tm_mon + 1 );
	else
		PF ("\n");
	}

	endutent();
}

