/*
    yamm, Yet Another Micro Monitor
    vm.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "define.h"
#include "extern.h"

#if defined(NCURSES)
# include "ncurses.h"
#else
# include <curses.h>
#endif /* NCURSES */

void Print_vm()
{
	struct pst_vminfo vbuf;
#if defined(linux)
	int i;
#endif /* linux */

#ifndef NO_CURSES
	if ( look_lines() < 24 ) {
		curses_error( "Sorry, you must have at least 24 lines." );
		vm_config = 0;
		return;
	}
#define PF (void)printw	
#else
#define PF (void)printf
#endif

	PS_vm ( &vbuf );

#if !defined(linux)
	PF ( "\n-----------------------------  SUM  ---------  RATIO\n");

	PF ( "Calls to syscall():   %12ld   |  %12ld\n",
		vbuf.psv_ssyscall, vbuf.psv_rsyscall );
	PF ( "Pages paged in:       %12ld   |  %12ld\n",
		vbuf.psv_spgpgin, vbuf.psv_rpgpgin );
	PF ( "Pages paged out:      %12ld   |  %12ld\n",
		vbuf.psv_spgpgout, vbuf.psv_rpgpgout );
	PF ( "Context switches:     %12ld   |  %12ld\n",
		vbuf.psv_sswtch, vbuf.psv_rswtch );
	PF ( "Device interrupts:    %12ld   |  %12ld\n",
		vbuf.psv_sintr, vbuf.psv_rintr );
	PF ( "\n-----------------------------  SUM  -----------------\n" );
#else
	PF ( "\n-----------------------------  SUM  ----------------\n");
	PF ( "Pages paged in:       %12ld\n",
		vbuf.psv_spgpgin );
	PF ( "Pages paged out:      %12ld\n",
		vbuf.psv_spgpgout );
	PF ( "Context switches:     %12ld\n",
		vbuf.psv_sswtch );
	PF ( "Total interrupts:     %12ld\n",
		vbuf.psv_sintr );
	PF ( "\n1 ... INTERRUPTS BY NUMBER ... 16\n" );
	for (i = 0; i < 16; i++)
		PF ( "%-3u ", vbuf.psv_interrupts[i] );
	PF ( "\n\n" );
#endif /* !linux */

	PF ( "Swapins:              %12ld\n", vbuf.psv_sswpin );
	PF ( "Swapouts:             %12ld\n", vbuf.psv_sswpout );
#if !defined(linux)
	PF ( "Number of forks:      %12ld\n", vbuf.psv_cntfork );
#endif /* !linux */
	PF ( "Pageins:              %12ld\n", vbuf.psv_spgin );
	PF ( "Pageouts:             %12ld\n" , vbuf.psv_spgout );
	PF ( "Pages swapped in:     %12ld\n", vbuf.psv_spswpin );
	PF ( "Pages swapped out:    %12ld\n", vbuf.psv_spswpout );
	PF ( "Total page reclaims:  %12ld\n", vbuf.psv_spgrec );
#if !defined(linux)
	PF ( "Calls to trap:        %12ld\n", vbuf.psv_strap );
#endif /* !linux */
	PF ( "Free memory pages:    %12ld  ( %s )\n", vbuf.psv_cfree, get_dimension ( vbuf.psv_cfree) );
}
