/*
    yamm, Yet Another Micro Monitor
    signals.c
    Copyright (C) 1994  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * signals.c
 * if contain the structure of the signals recognized by the system
 */

#include <stdlib.h>
#include <signal.h>

#include "define.h"
#include "extern.h"

#if defined(STRFY)
#define _S(signal) { #signal, signal }
#else
#define _S(signal) { "UNKNOWN", signal }
#endif /* STRFY */

/*
 * Check the signames structure for lost signals on your system
 * Add the ones you have and are not alredy present, enclosed by #if/#endif
 * Use the macro _S(SIGNAL)
 */

struct Signames signames [] = {
#if defined(SIGINT)
	_S(SIGHUP),
#endif
#if defined(SIGINT)
	_S(SIGINT),
#endif
#if defined(SIGQUIT)
	_S(SIGQUIT),
#endif
#if defined(SIGILL)
	_S(SIGILL),
#endif
#if defined(SIGTRAP)
	_S(SIGTRAP),
#endif
#if defined(SIGABRT)
	_S(SIGABRT),
#endif
#if defined(SIGIOT)
	_S(SIGIOT),
#endif
#if defined(SIGEMT)
	_S(SIGEMT),
#endif
#if defined(SIGUNUSED)
	_S(SIGUNUSED),
#endif
#if defined(SIGFPE)
	_S(SIGFPE),
#endif
#if defined(SIGKILL)
	_S(SIGKILL),
#endif
#if defined(SIGBUS)
	_S(SIGBUS),
#endif
#if defined(SIGUSR1)
	_S(SIGUSR1),
#endif
#if defined(SIGSEGV)
	_S(SIGSEGV),
#endif
#if defined(SIGSYS)
	_S(SIGSYS),
#endif
#if defined(SIGUSR2)
	_S(SIGUSR1),
#endif
#if defined(SIGPIPE)
	_S(SIGPIPE),
#endif
#if defined(SIGALRM)
	_S(SIGALRM),
#endif
#if defined(SIGTERM)
	_S(SIGTERM),
#endif
#if defined(SIGSTKFLT)
	_S(SIGSTKFLT),
#endif
#if defined(SIGCHLD)
	_S(SIGCHLD),
#endif
#if defined(SIGCLD)
	_S(SIGCLD),
#endif
#if defined(SIGCONT)
	_S(SIGCONT),
#endif
#if defined(SIGSTOP)
	_S(SIGSTOP),
#endif
#if defined(SIGTSTP)
	_S(SIGTSTP),
#endif
#if defined(SIGTTIN)
	_S(SIGTTIN),
#endif
#if defined(SIGTTOU)
	_S(SIGTTOU),
#endif
#if defined(SIGIO)
	_S(SIGIO),
#endif
#if defined(SIGPOLL)
	_S(SIGPOLL),
#endif
#if defined(SIGURG)
	_S(SIGURG),
#endif
#if defined(SIGXCPU)
	_S(SIGXCPU),
#endif
#if defined(SIGXFSZ)
	_S(SIGXFSZ),
#endif
#if defined(SIGVTALRM)
	_S(SIGVTALRM),
#endif
#if defined(SIGPROF)
	_S(SIGPROF),
#endif
#if defined(SIGWINCH)
	_S(SIGWINCH),
#endif
#if defined(SIGWINDOW)
	_S(SIGWINDOW),
#endif
#if defined(SIGLOST)
	_S(SIGLOST),
#endif
#if defined(SIGPWR)
	_S(SIGPWR),
#endif
#if defined(SIGRESERVE)
	_S(SIGRESERVE),
#endif
#if defined(SIGDIL)
	_S(SIGDIL),
#endif
	{ NULL, 0 }
};

#if defined(SIGWINCH) && defined(OWN_WINCH)
/*
 * this is defined into ifdef because of the system-specific behaviour
 * of the signal management
 */
void winch_func( sig )
int sig;
{
# if defined(linux) || defined(hpux)
	signal(SIGWINCH, winch_func);
#endif /* linux || hpux */

do_chsize();
}
#endif /* SIGWINCH && OWN_WINCH */
