/*
    yamm, Yet Another Micro Monitor
    main.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define _MAIN
#if defined(NCURSES)
# include "ncurses.h"
#else
# include <curses.h>
#endif /* NCURSES */
#include <pwd.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/user.h>
#if !defined(linux)
# include <sys/proc.h>
#endif /* !linux */
#include <sys/stat.h>
#if !defined(linux)
# include <sys/ptyio.h>
#endif /* !linux */
#include <sys/sysmacros.h>
#if defined(linux)
# include <signal.h>

/*
 * hmmm ... this #undef needed to remove an annoying message.
 * Be sure to not use the HZ (curses) macro in this file: you may use instead
 * the HZ system clock granularity, defined in sched.h
 */
# undef HZ
# undef INT_MAX
# undef UINT_MAX
# undef LONG_MAX
# undef ULONG_MAX
# include <linux/sched.h>
#endif /* linux */

#include "define.h"
#include "extern.h"

#ifndef lint
static char *_yamm1 =
	"@(#) YAMM ( Yet Another Micro Monitor ) " YAMM_VERSION " by Facchetti Riccardo, from V2.4 by Marangoni Andrea";
static char *_yamm2 =
	"@(#) E-mail: riccardo@cdc8g5.cdc.polimi.it";
#endif


#ifndef NO_CURSES
static char *cmd_line = "mN:CVdEDeiswtcr%u:SUP:W:/:";
#else
static char *cmd_line = "mN:CVdDEeiswtcr%Lu:SUP:W:/:";
#endif

static char *get_command();
static void Look_process();
static int init_yamm();

int main( ac, av )
int ac;
char *av[];
{
	int ret,i,j;
	struct pst_dynamic dinfo;

/*
 * Do this to elide the bastard warning messages about _yamm1 and _yamm2 unused
 */
	ret = strlen(_yamm1);
	ret = strlen(_yamm2);

#if defined(SIGWINCH) && defined(OWN_WINCH)
	yammav = av;
#endif /* SIGWINCH && OWN_WINCH */

	if (!init_yamm())
		printf ("yamm: initialization error\n"), exit(1);

/* Thanks to Harald Vogt <harald@cs.ruu.nl> for ideas and suggestions */

	order = compare_sched_time; /* HV */
	mpreprocess ( ac, av, cmd_line );

	if ( ( ret = PS_proc ( &pbuf, MAX_PROC, 0 )) == -1 )
		( void )perror ( "Pstat: PSTAT_PROC" ), exit ( 1 );

	set_users ();

#ifndef NO_CURSES
	( void )fflush ( stdout );
	setup_tty();
	init_curses();
#else
	count_status ( ret );
	printf ( "Number of processes in system: %d\n",ret );
	printf ( "    %d Running, %d Sleeping, %d Stopped, %d Zombie, %d Other.\n",
		status_run(), status_sleep(),status_stop(),
		status_zombie(),status_other());
#endif

#if defined(linux)
	read_ftab();
#endif /* linux */

	goto first_time;  /* Not really needed */

	do {

#ifndef NO_CURSES
		curses_print_help();
		curses_refresh();
#else
		fflush ( stdout );
#endif
		
#ifndef NO_CURSES
		( void )curses_wait ( wait_second );
#else
		( void )sleep ( wait_second <= 0 ? 1 : wait_second );
#endif

first_time:   /* First time avoid sleep */

		if ( ( ret = PS_proc ( &pbuf, MAX_PROC, 0 ) ) == -1 )
			( void )perror ( "Pstat: PSTAT_PROC" ), exit ( 1 );

		PS_dynam ( &dinfo );

#ifndef NO_CURSES
		update_first_line( ret, &dinfo  );	
#define PF (void)printw
#else
		if ( Num_display_proc == -1 )
			Num_display_proc = ret;
#define PF (void)printf
#endif

		if ( who ) {
			Print_Who( ret ); 
			continue;
		}

		if ( look_utmp ) {
			examine_utmp();
			continue;
		}

		if ( look_process >= 0 ) {
			Look_process ( look_process, ret );
			continue;
		}

		if ( print_configuration ) {
			Print_Conf( ret, &dinfo );
			continue;
		}


		if ( vm_config ) {
			Print_vm();
			continue;
		}
	
		if ( order )
			( void ) qsort ( ( void *)pbuf, ( size_t )ret,
			( size_t )sizeof ( struct pst_status ), order );

#if !defined(linux)
		if ( look_cols() >= 90 || wcpu )
			PF ( "\nS  USER       SUID   PID NI PRI    SIZE     RSS  %%WCPU   %s%cTIME CMD\n",
				look_cols() >= 90 ? "STIME    " : "",
				system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's');
		else
			PF ( "\nS  USER       SUID   PID NI PRI    SIZE     RSS   STIME    %cTIME CMD\n",
				system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's');
#else
#if defined(MOD)
		if ( look_cols() >= 90 || wcpu )
			PF ( "\nS  USER       SUID   PID NI PRI    SIZE     RSS  %%WCPU     WCHAN    %s%s%c%s CMD\n",
				look_cols() >= 90 ? "STIME   " : "",
				look_cols() >= 100 ? "   ":"",
				look_cols() >= 100 ? (system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's') : ' ',
				look_cols() >= 100 ? "TIME" : "");
		else
			PF ( "\nS  USER       SUID   PID NI PRI    SIZE     RSS   STIME    %cTIME CMD\n",
				system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's');
#else
		if ( look_cols() >= 90 || wcpu )
			PF ( "\nS  USER       UID    PID NI PRI    SIZE     RSS  %%WCPU     WCHAN    %s%s%c%s CMD\n",
				look_cols() >= 90 ? "STIME   " : "",
				look_cols() >= 100 ? "   ":"",
				look_cols() >= 100 ? (system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's') : ' ',
				look_cols() >= 100 ? "TIME" : "");
		else
			PF ( "\nS  USER       UID    PID NI PRI    SIZE     RSS   STIME    %cTIME CMD\n",
				system_time_include & user_time_include ? ' ':
				user_time_include ? 'u' : 's');
#endif /* MOD */
#endif /* !linux */


		for ( i = j = displayed = 0, reverse_index = -1; i < ret; ++i) {

			if ( look_uid >= 0L && pbuf [ i ].pst_uid != look_uid )
				continue; /* -U option */

			if ( !allow_root && !pbuf [ i ].pst_uid )
				continue; /* !-R option */

			if ( set_euid  && pbuf [ i ].pst_uid == pbuf [ i ].pst_suid)
				continue; /* -E option */

			if ( sstring && !reg_match ( pbuf [ i ].pst_cmd ))
				continue;

#ifndef NO_CURSES
			if ( j++ < pages*Num_display_proc )
				continue;
#endif
			if ( Num_display_proc >= 0 && displayed >= Num_display_proc )
				break;

			displayed++;

#ifndef NO_CURSES
			if ( reverse == displayed  ) {
				reverse_index = i;
				curses_in_reverse();	
			}
#endif

			PF ( "%c%c %-*s %c%5ld %5ld %2ld %3ld %s ",
				get_status ( i ),
				pbuf [ i ].pst_rssize ? ' ' : 'W',
				MAX_LOGIN,
				get_user ( i ),
				pbuf [ i ].pst_uid != pbuf [ i ].pst_suid ? '*':' ',
				pbuf [ i ].pst_suid,
				pbuf [ i ].pst_pid,
				pbuf [ i ].pst_nice,
				pbuf [ i ].pst_pri,
#if !defined(linux)
				get_dimension (  pbuf [ i ].pst_dsize +
					pbuf [ i ].pst_tsize  + pbuf [ i ].pst_ssize ) );
#else
				get_dimension (  pbuf [ i ].pst_vsize ) );
#endif /* linux */

			PF ( "%s ",
				get_dimension ( pbuf [ i ].pst_rssize ));

			/* printw seems don't well work */
			if ( look_cols () >= 90 || wcpu ) {  /* xterm ? */
				double pcpu = pbuf [ i ].pst_pctcpu * 100.00;
#if defined(linux)
				int q = search_func (pbuf [ i ].pst_wchan);
#endif /* linux */

				/*  Bad trick here */
				PF ( "%2d.%.2d%% ", ( int )pcpu,
					( int )(( pcpu - ( int )pcpu) * 100.00 ));
#if defined(linux)
				if ( q == -1 )
					PF ( " 0x%.8x ", pbuf [ i ].pst_wchan);
				else
					PF ( "%12.12s ", ftab [ q ].name );
#endif /* linux */
			}

			if ( !wcpu )
				PF ( "%s ",
				visual_start_time ( i ));
#if defined(linux)
			if ( !wcpu && (look_cols() < 90 || look_cols() >= 100) ) {
				PF ( ( pbuf [ i ].pst_trs != 0 ? "%s %s\n" : "%s (%s)\n"),
					visual_user_time ( i ),
					long_format ? pbuf [ i ].pst_cmd : get_command ( i ));
			}
			else {
				PF ( ( pbuf [ i ].pst_trs != 0 ? "%s\n" : "(%s)\n"),
					long_format ? pbuf [ i ].pst_cmd : get_command ( i ));
			}
#else
			PF ( "%s %s\n",
				visual_user_time ( i ),
				long_format ? pbuf [ i ].pst_cmd : get_command ( i ));
#endif /* linux */

#ifndef NO_CURSES
			if ( reverse == displayed )
				curses_out_reverse();	
#endif
		}

		if ( reverse_index == -1 )
			reverse = 0;

		if ( displayed == 0 && look_uid >= 0 && !pages ) {
#ifdef NO_CURSES
			PF ( "No such uid: %ld\n", look_uid );
#else
			curses_error ( "No such uid." );
#endif
			look_uid = -1;
		}

#undef PF
	} while ( wait_second >= 0 );


#ifndef NO_CURSES
	quit ( 0 );
#endif
	return ( 0 );
}

static char *get_command ( index )
int index;
{
	extern char *strtok();
	char *first_string = pbuf [ index ].pst_cmd ?
		strtok (  pbuf [ index ].pst_cmd , " \t\n" ) : "???";

	char *last_cmd = strrchr ( first_string, '/' );

	return (  last_cmd ? last_cmd + 1 : first_string );
}

static void Look_process ( process, num )
long process;
int num;
{
	extern char *ctime();
	register int i;

	for ( i = 0; i < num && process!= pbuf[ i ].pst_pid; ++i );

#define PP (*myps)

#ifdef NO_CURSES
#define PF (void)printf

#else
#define PF (void)printw
	if ( look_lines() < 24 ) {
		curses_error( "Sorry, you must have at least 80 cols." );
		look_process = -1;
		return;
	}


#endif

	if ( PS_proc ( &myps, 0, process ) == -1 )
#ifdef NO_CURSES
		( void )perror ( "Pstat: PSTAT_PROC" ),exit ( 1 );
#else
		{
			curses_error( "No such process......." );
			look_process = -1;
			return;
		}
#endif

#if defined(linux)
switch (pages) {
    case 0:
#endif /* linux */

	PF ( "\nUID                                  : %ld  %s\n",
		PP.pst_uid, get_user ( i ));
#if !defined(linux) || defined(MOD)
	PF ( "Process SUID                         : %ld\n", PP.pst_suid );
#endif /* !linux || MOD */
#if !defined(linux)
	PF ( "Process ID                           : %ld\n", PP.pst_pid );
	PF ( "Parent process ID                    : %ld\n", PP.pst_ppid );
#else
	PF ( "Process ID, Parent ID, Session ID    : %ld, %ld, %d\n",
		PP.pst_pid,
		PP.pst_ppid,
		PP.pst_session );
#endif /* !linux */
#if defined(linux)
	PF ( "Memory size, resident, swap, shared  : %s, ",
		get_dimension ( PP.pst_size ));
	PF ( "%s, ",
		get_dimension ( PP.pst_resident ));
	PF ( "%s, ",
		get_dimension ( PP.pst_size - PP.pst_resident ));
	PF ( "%s\n",
		get_dimension ( PP.pst_share ));
	PF ( "t(ext)rs, l(ib)rs, d(ata)rs, dt      : %s, ",
		get_dimension ( PP.pst_trs ));
	PF ( "%s, ",
		get_dimension ( PP.pst_lrs ));
	PF ( "%s, ",
		get_dimension ( PP.pst_drs ));
	PF ( "%s\n",
		get_dimension ( PP.pst_dt ));
#else
	PF ( "Process data, text, stack size       : %s, ",
		get_dimension ( PP.pst_dsize ));
	PF ( "%s, ",
		get_dimension ( PP.pst_tsize ));
	PF ( "%s\n",
		get_dimension ( PP.pst_ssize ));
#endif /* linux */
	PF ( "Resident set size for process        : %-5ld Pages ( %s )\n",
		PP.pst_rssize, get_dimension ( PP.pst_rssize ));
	PF ( "Nice, Priority                       : %ld, %ld\n",
		PP.pst_nice,
		PP.pst_pri );
	PF ( "Process group                        : %ld\n", PP.pst_pgrp );
	PF ( "User time spent executing            : %ld Sec.\n", 
		PP.pst_utime );
	PF ( "System time spent executing          : %ld Sec.\n",
		PP.pst_stime );
	PF ( "Start time                           : %s",
		ctime ( &PP.pst_start ));
	PF ( "Current status                       : %c\n",
		get_status ( i ));
#if defined(linux)
	PF ( (PP.pst_trs != 0 ? "Command the proc is running          : %s\n" :
		"Command the proc is running          : (%s)\n") , PP.pst_cmd );
#else
	PF ( "Command the proc is running          : %s\n",
		PP.pst_cmd );
#endif /* linux */
	PF ( "Terminal associated to the process   : %s\n",
#if !defined(linux)
		get_tty ( PP.pst_term.psd_major, PP.pst_term.psd_minor ));
	PF ( "Resident time for scheduling         : %ld\n", PP.pst_time );
#else
                PP.pst_tty);
	PF ( "Timeout time for scheduling          : %ld\n", PP.pst_time );
#endif /* !linux */
	PF ( "Ticks of cpu time                    : %ld\n",
		PP.pst_cpticks);
	PF ( "Total ticks for life of process      : %ld\n",
		PP.pst_cptickstotal );
	PF ( "%%cpu for this process during p_time  : %f%%\n",
		PP.pst_pctcpu * 100.00 );

#if defined(linux)
#ifndef NO_CURSES
	move ( LINES - 2 , 0 );
#endif
	PF ( "Type 'f' to next page or <RETURN> to exit." );
	break;

    default:
	pages = 1;
    case 1:

	PF ( "\nItimer real value                    : %ld Sec.\n",
		PP.pst_it_real_value );
	PF ( "Major Page Faults                    : %ld\n",
		PP.pst_maj_flt );
	PF ( "Major Children Page Faults           : %ld\n",
		PP.pst_cmaj_flt );
	PF ( "Minor Page Faults                    : %ld\n",
		PP.pst_min_flt );
	PF ( "Minor Children Page Faults           : %ld\n",
		PP.pst_cmin_flt );
	PF ( "Process flags                        : %s%s%s\n",
		(PP.pst_flags & PF_ALIGNWARN) ? "PF_ALIGNWARN " : "",
		(PP.pst_flags & PF_PTRACED) ? "PF_PTRACED " : "",
		(PP.pst_flags & PF_TRACESYS) ? "PF_TRACESYS " : "" );
	PF ( "WCHAN                                : 0x%lx",
		PP.pst_wchan );
	if ((i = search_func ( PP.pst_wchan )) == -1)
		PF ( "\n" );
	else
		PF ( " (%s)\n", ftab [ i ].name);

#define M0 "0"
#define M1 "1"

	PF ( "\n           SIGNAL MASKS              : 1  ...   SIGNAL NUMBER   ...  %d\n", NSIG );
	PF ( "Pending signals mask                 : " );
		for (i = 0; i < NSIG; i++)
			if ((1 << i) & PP.pst_signal)
				PF ( M1 );
			else
				PF ( M0 );
	PF ( "\n" );
	PF ( "Blocked signals mask                 : " );
		for (i = 0; i < NSIG; i++)
			if ((1 << i) & PP.pst_blocked)
				PF ( M1 );
			else
				PF ( M0 );
	PF ( "\n" );
	PF ( "Ignored signals mask                 : " );
		for (i = 0; i < NSIG; i++)
			if ((1 << i) & PP.pst_sigignore)
				PF ( M1 );
			else
				PF ( M0 );
	PF ( "\n" );
	PF ( "Catched signals mask                 : " );
		for (i = 0; i < NSIG; i++)
			if ((1 << i) & PP.pst_sigcatch)
				PF ( M1 );
			else
				PF ( M0 );
	PF ( "\n" );
#ifndef NO_CURSES
	move ( LINES - 2 , 0 );
#endif
	PF ( "Type 'b' to previous page or <RETURN> to exit." );
	break;
}

#undef M0
#undef M1
#endif /* linux */

#undef PP
#undef PF
}

static int init_yamm()
{

#ifndef NO_CURSES
	wait_second = 4;
#endif

/*
 * this is needed due to dinamic allocation of process buffers
 */
	myps = ( struct pst_status * )malloc ( sizeof (struct pst_status ) );

#if defined(MOD)
/*
 * open /dev/yamm and keep it opened until exit
 */
	yammfd = open ("/dev/yamm", O_RDONLY);
	if (yammfd == -1) {
		printf( "Cannot open /dev/yamm (drv_yamm.o not loaded)\n" );
		return ( 0 );
	}
#endif /* MOD */
	return ( 1 );
}
