/*
    yamm, Yet Another Micro Monitor
    get_tty.c
    Copyright (C) 1994  Riccardo Facchetti && Andrea Marangoni

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <sys/sysmacros.h>

/* This code is in scandir manual page */

typedef struct _mtty {
	int error;
	char name [ MAXNAMLEN + 1 ];
	struct stat stty;
} MTTY;

#define SMTTY    (sizeof(MTTY))
#define BUF      32

static MTTY *list_tty = NULL, *list_pty = NULL;
static char *unknown = "Unknown";
static int n_tty = 0, n_pty = 0;

void setup_tty()
{
	struct dirent **namelist, **list;
	register MTTY *next;
	register int i;
	char buf [ MAXNAMLEN + 16 ];

/*********************************** TTY ******************************/
	if ( ( n_tty = scandir("/dev", &namelist, NULL, NULL)) <= 0) 
		return;

	if ( ( list_tty = ( MTTY *)malloc ( n_tty* SMTTY )) == NULL )
		return;

	for ( next = list_tty, i = 0, list = namelist;
		i < n_tty && next;      ++i, ++next, list++ ) {

		strcpy ( buf,"/dev/" );
		strcat ( buf, (*list)->d_name );
		buf [ MAXNAMLEN + 15 ] = '\0';

		if ( stat ( buf, &(next->stty) ) == -1 )
			next->error = 1;
		else
			next->error = 0;

		strncpy ( next->name, (*list)->d_name,  MAXNAMLEN );
		next->name [ MAXNAMLEN ] = '\0';
		free((void *)*list);
	}

/*********************************** PTY ******************************/
	if ( ( n_pty = scandir("/dev/pty", &namelist, NULL, NULL)) <= 0) 
		return;

	if ( ( list_pty = ( MTTY *)malloc ( n_pty* SMTTY )) == NULL )
		return;

	for ( next = list_pty, i = 0, list = namelist;
		i < n_pty && next;      ++i, ++next, list++ ) {

		strcpy ( buf,"/dev/pty/" );
		strcat ( buf, (*list)->d_name );
		buf [ MAXNAMLEN + 15 ] = '\0';

		if ( stat ( buf, &(next->stty) ) == -1 )
			next->error = 1;
		else
			next->error = 0;

		strncpy ( next->name, (*list)->d_name,  MAXNAMLEN );
		next->name [ MAXNAMLEN ] = '\0';
		free((void *)*list);
	}
}

/* 
	In stat.h: #define S_ISCHR(_M)  ((_M & _S_IFMT)==_S_IFCHR)
	Test for char special.
*/

static char *info_tty ( pointer )
MTTY *pointer;
{
	static char buf [ BUF ];

	if ( !pointer || pointer->error)
		return ( unknown );

	/* BUF << MAXNAMLEN */
	strncpy ( buf, pointer->name, BUF - 14 );
	buf [ BUF - 14 ] = '\0';

	sprintf ( buf + strlen ( buf ), " (%c%c%c%c%c%c%c%c%c)",
		pointer->stty.st_mode & S_IRUSR ? 'r' : '-',
		pointer->stty.st_mode & S_IWUSR ? 'w' : '-',
		pointer->stty.st_mode & S_IXUSR ? 'x' : '-',
		pointer->stty.st_mode & S_IRGRP ? 'r' : '-',
		pointer->stty.st_mode & S_IRGRP ? 'w' : '-',
		pointer->stty.st_mode & S_IRGRP ? 'x' : '-',
		pointer->stty.st_mode & S_IROTH ? 'r' : '-',
		pointer->stty.st_mode & S_IROTH ? 'w' : '-',
		pointer->stty.st_mode & S_IROTH ? 'x' : '-' );

	buf [ BUF - 1 ] = '\0';
	return ( buf );
}
	

/* major(x) and minor(x) are macros defined in sysmacros.h */

char *get_tty ( m_major, m_minor )
long m_major, m_minor;
{
	register MTTY *next = NULL;
	register int i;

	if ( m_major == -1 && m_minor == -1 )
		return ( "?" );
	
	for ( i = 0, next = list_tty; i < n_tty && next; ++i, ++next ) 

		if ( !next->error &&
		S_ISCHR(next->stty.st_mode) && 
		major(next->stty.st_rdev) == m_major &&
		minor(next->stty.st_rdev) == m_minor )
			return ( info_tty ( next ) );


	for ( i = 0, next = list_pty; i < n_pty && next; ++i, ++next )

		if ( !next->error &&
		S_ISCHR(next->stty.st_mode) && 
		major(next->stty.st_rdev) == m_major &&
		minor(next->stty.st_rdev) == m_minor )
			return ( info_tty ( next ) );

	return ( unknown );
}
