
%{
#define YYSTYPE char *
#include "sesh.h"
#include "hache.h"

#undef YYLMAX
#define YYLMAX 10240
#include <string.h>
#define G(x) {yylval=g(x); return HIEROGLYPHE;}
#define Commence(x) BEGIN(x); etat=x;

extern char * genere();
extern char * yylval ;

char * traite();
char *g();
char * nomdefine;
char tempor [1000]= "";
/*FILE * indexmots;*/
TABLE signes;
TABLE definitions;
TABLE phonetiques;
int dieze=0;
int etat= INITIAL;

%}

entier    ([0-9]+)
gardiner  (([A-Z]|Aa){entier}a*)
ident     ([a-zA-Z.']+)
ESPS	  ([ \t\n]*)

%s DEFINE0 DEFINE1 HieroText TEXTEIMBR
%p 4000

%%
                 switch(etat)
		 	{ case INITIAL: BEGIN(INITIAL);break;
			  case HieroText: BEGIN(HieroText);break;
                        }

<INITIAL>(.|\n)			{ECHO; return TEXTE;}
<INITIAL>"\\begin{hieroglyph}"[ \n\t]*	{printf("\\begin{hieroglyph}%%\n"); /* } emacs */
					; Commence(HieroText); return DEBUTHIEROGS;}

<DEFINE0>[ \t]+			BEGIN(DEFINE1);
<DEFINE1>.*            		{stocke(nomdefine, strdup(yytext)); Commence(HieroText);}
<HieroText>^[ \t]+              ; /* On ignore superbement les espaces en debut de ligne */
<HieroText>"\\end{hieroglyph}"   { Commence(INITIAL); return FINHIEROGS;}
<HieroText>D:d	       		{yylval= genere("\\ligAROBDd%\n", NULL);
					return HIEROGLYPHE;}
<HieroText>D:t			{yylval= genere("\\ligAROBDt%\n", NULL);		
					return HIEROGLYPHE;}
<HieroText>D:ra			{yylval= genere("\\ligAROBDra%\n", NULL);		
					return HIEROGLYPHE;}
<HieroText>{ident}		|
<HieroText>([A-Z]|Aa){entier}A*	{if (!(yylval =g(yytext,0))) {REJECT } else return HIEROGLYPHE;}
<HieroText>\\{ident}		|
<HieroText>\\([A-Z]|Aa){entier}A*	{if (!(yylval =g(yytext+1,1))) {REJECT } else return HIEROGLYPHE;}
<HieroText>","{ident}	        {traite(yytext+1);}
<HieroText>\#def([ \t]+){ident} { int i;
                                  for (i=4; yytext[i]
				   && (yytext[i] == ' ' || yytext[i]== '\t');
				   i++);
			 	   if  (yytext[i])
			 	     {
			               nomdefine=strdup(yytext+i);
			               BEGIN (DEFINE0);
			             }
				   else
				     yyerror("Mauvaise definition\n");
		                }
<HieroText>"<"			return CARTO;
<HieroText>"<b"{ESPS}		return DEBCARTO;
<HieroText>"<m"{ESPS}		return MILCARTO;
<HieroText>"<e"{ESPS}		return FINCARTO;
<HieroText>">"			return CARTF;
<HieroText>[ \t]+		return ESPACE;
<HieroText>"="			return '-';
<HieroText>"-="			return '-';
<HieroText>":="			return ':';
<HieroText>" :"		        {unput(':'); return INTERNALSPACE;}
<HieroText>"+l"			BEGIN(TEXTEIMBR);
<HieroText>" -"			return ESPACE;
<HieroText>\\!			return KERNING;
<HieroText>"."			return POINT;
<HieroText>".."			return POINTPOINT;
<HieroText>{ident}		{traite(yytext);}
<HieroText>\-?"#"\-?		|
<HieroText>"#"			{ dieze=1-dieze; /* ne compliquons pas la grammaire */
				  if (dieze==1) return DIEZE0;
				     else return DIEZE1;}

<HieroText>\\			yymore();
<HieroText>(\n|.)		return yytext[0];

<TEXTEIMBR>"+s"			{yylval= strdup(yytext); 
				 yylval[strlen(yylval)-2]=0;
				 return ROMAIN;
                                }
<TEXTEIMBR>(.|\n)	        yymore();

%%


struct donne {
  char * entree;
  char * phon;
  struct caractere {char *sym; unsigned  char numero;} symbole;
};

char *g(x, sens) 
     char *x; int sens;
{
  struct caractere* txt;
  if (txt=(struct caractere*)trouve(x,signes))
    {
      static char tmp[6];
      int nombre= sens*128 + txt->numero;
      sprintf(tmp,"%u",nombre);
      phonetique(trouve(x,phonetiques));
      return  (genere("\\convertir{\\AROBtaille}", 
		    txt->sym,
		    "/",
		    tmp,		    
		    "\\relax%%\n", 0));
    }
  else
    return NULL;
}


char *traite(texte)
     char * texte;
{
  int i;
  char *result;
  if (result= trouve(texte, definitions))
    {
      for (i=strlen(result) -1; i> -1; i--)
	unput(result[i]);		
    }
  else
    {
     	printf( "texte non reconnu: %s\n", texte);
    }
}

resetmot()
{
  tempor[0]=0;
}

phonetique(s)
     char * s;
{
  strcat(tempor,"-");
  strcat(tempor,s);
}

char *simplifie()
{
  /* X-XY-Y => XY */
  /* X-Y-XY => XY */
  /* XY-X-Y => XY */
  /* XYZ-X-Y-Z=> XYZ */
  /* XYZ-Y-Z=>XYZ */
}

representation()
{
/*  fprintf(indexmots, "%s\n", tempor);
  resetmot();*/
}


int stocke(nom, valeur)
     char *nom, *valeur;
{
  insere(nom,valeur,definitions);
}

 struct donne les_donnees[]=
{
#include "seshSource.h"
    {0,0,{0,0}}
}
;

initialise_lex()
{
  struct donne *i;
  signes= creer_table();
  definitions= creer_table();
  phonetiques= creer_table();
  /* indexmots= fopen("index.mot", "w");*/
  /* fflush(indexmots); */
  
  for (i= les_donnees; i->entree; i++)
    {
      insere(i->entree,&(i->symbole), signes);
      insere(i->entree,i->phon, phonetiques);
    }
}
