/* $Id: convert.c,v 1.5 94/05/28 00:00:41 budd Exp $ */

/*
 * convert from strings to numbers using strto[ld]
 * strto[ld] are in SVID2, XPG2, XPG3, ANSI C
 */

#include "h.h"
#include "snotypes.h"
#include "macros.h"

#include "equ.h"			/* for I and R */
int
spcint(dp, sp)
    struct descr *dp;
    struct spec *sp;
{
    char buffer[64];			/* ??? */
    int_t len;
    char *cp;
    int_t temp;

    len = S_L(sp);
    cp = S_SP(sp);

    bcopy( cp, buffer, len );
    buffer[len] = '\0';

    temp = strtol( buffer, &cp, 10);	/* always decimal */
    if (*cp)
	return FALSE;			/* failure */

    D_A(dp) = temp;
    D_F(dp) = 0;			/* clear flags */
    D_V(dp) = I;			/* set type */

    return TRUE;			/* success */
}

int
spreal(dp, sp)
    struct descr *dp;
    struct spec *sp;
{
    char buffer[64];			/* ??? */
    int len;
    char *cp;
    float temp;
    double strtod();

    len = S_L(sp);
    cp = S_SP(sp);

    bcopy( cp, buffer, len );
    buffer[len] = '\0';

    temp = strtod( buffer, &cp, 10);	/* always decimal */
    if (*cp)
	return FALSE;			/* failure */

    D_RV(dp) = temp;
    D_F(dp) = 0;			/* clear flags */
    D_V(dp) = R;			/* set type */

    return TRUE;			/* success */
}
