;;; tex-lcd.el - Special support for Lucid Emacs 

;; Author: Per Abrahamsen <abraham@iesd.auc.dk>
;; Version: $Id: tex-lcd.el,v 5.12 1994/04/20 16:59:02 amanda Exp $

;;; Code:

(defun TeX-active-mark ()
  ;; In Lucid (mark) returns nil when not active.
  (mark))

(defun TeX-mark-active ()
  (and zmacs-regions (mark)))

(add-menu-item '("Help") "Document LaTeX word..." 'latex-help t "-----")

;; Lucid 19.6 grok this regexp, but you loose the ability to use
;; whitespace in your documentstyle command.
(string-match "\\`[0-9]+\\.\\([0-9]+\\)" emacs-version)
(or (> (string-to-int (substring emacs-version
				 (match-beginning 1) (match-end 1)))
       8)
    (> (string-to-int emacs-version) 19)
    (boundp 'LaTeX-auto-minimal-regexp-list)
    (setq LaTeX-auto-minimal-regexp-list
     '(("\\\\documentstyle\\[\\([^#\\\\\\.\n\r]+\\)\\]{\\([^#\\\\\\.\n\r]+\\)}"
        (1 2) LaTeX-auto-style)
       ("\\\\documentstyle{\\([^#\\\\\\.\n\r]+\\)}" (1) LaTeX-auto-style)
       ("\\\\documentclass\\[\\([^#\\\\\\.\n\r]+\\)\\]{\\([^#\\\\\\.\n\r]+\\)}"
        (1 2) LaTeX-auto-style)
       ("\\\\documentclass{\\([^#\\\\\\.\n\r]+\\)}" (1) LaTeX-auto-style))))

(provide 'tex-lcd)

;;; tex-lcd.el ends here



