/*
 * regex_replace.c : replace strings using regex search exp.
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#include <sys/types.h>
#include <regex.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define NMATCH 	1
#ifndef POSIX
#define POSIX	/* doesn't work otherwise */
#endif

#ifndef POSIX
#define regcomp(preg, regex, flags)	re_compile_pattern(regex, strlen(regex), preg)
#define regexec(preg, string, nmatch, pmatch, eflags)	re_search(preg, string, strlen(string), 0, strlen(string), &pmatch)
#endif

char *regex_replace(regex_t *preg, const char *string, const char *replace)
{
#ifdef POSIX
	regmatch_t pmatch[NMATCH];
#else
	struct re_registers pmatch;
#endif
	char *tmp;
	static char newstring[1024];

	if (newstring != string)
		strcpy(newstring, string);

	/* look for the regex in string */

	while (regexec(preg, newstring, NMATCH, pmatch, 0) == 0) {

	/* put a NUL at the start of every match */

		tmp = strdup(newstring);
/*	
		printf("regex_replace: match at %d-%d\n", 
		  pmatch[0].rm_so, pmatch[0].rm_eo);
 */

#ifdef POSIX 
		*(tmp + pmatch[0].rm_so) = '\0';
#else
		*(tmp + pmatch.start[0]) = '\0';
#endif

		/* cat together pieces of unmatched string with replacement */
	
		strcpy(newstring, tmp);
		strcat(newstring, replace);
#ifdef POSIX
		strcat(newstring, tmp + pmatch[0].rm_eo);
#else
		strcat(newstring, tmp + pmatch.end[0]);
#endif
		free(tmp);
	}
	return newstring;
}
