/* 
 * order.c 
 * 
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * code to order an ':' separated set of filenames within
 * a string, according to the hierarchy of *std_sections[]
 * - reverse order of priority used, as this is later re-reversed.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "config.h"
#include "gripes.h"

#define ELEMENTS        50       /* Max man files per database key */

#ifdef linux			 /* predefined by gcc */
#define COMPARE_FN __compar_fn_t /* to get rid of the annoying warning */
#else
#define COMPARE_FN int
#endif

extern char *prognam;
extern int debug;

/*
 * Try and keep this one as fast as possible.
 * -- the compare function --
 * decides the priority of manpages, based upon *std_sections[]
 *
 * This routine will only work for single character sections !!
 */

int compare(char **page1, char **page2)
{
   /* static char *std_sections[] = { "1", "2", ... , NULL } */

	register char *sec1, *sec2;
	char **sec_list;
#ifdef COMP_SRC
	extern struct compress_ext decompress[];
	struct compress_ext *comp;
#endif

	sec1 = strrchr(*page1, '.');
	sec2 = strrchr(*page2, '.');

#ifdef COMP_SRC
	/* need to check for compression ext */

	for (comp = decompress; comp->ext; comp++)
		if (strcmp(sec1, comp->ext) == 0) {
			sec1 -= 2;
			break;
		}	

	for (comp = decompress; comp->ext; comp++)
		if (strcmp(sec2, comp->ext) == 0) {
			sec2 -= 2;
			break;
		}
#endif
	if (*(++sec1) == *(++sec2)){
		if (debug)
			fprintf(stderr, "\ncompare: unlikely scenario of equal sections\n\t%s\n\t%s\n\n",
			  *page1, *page2);
		return 0;
	}
	 
	for (sec_list = std_sections; *sec_list; sec_list++) {

		if (*sec1 == **sec_list)
			return -1;
		
		if (*sec2 == **sec_list)
			return 1;
	}
	/* big BIG problems if we ever reach here */

	fprintf(stderr,"%s: compare: neither %c (%s) or %c (%s) appear to exist in section list -"
	 " cannot order pages.\n", prognam, *sec1, *page1, *sec2, *page2);
	exit(1);
}

char *orderthem(char *newpage, char *list)
{
	char *substring[ELEMENTS];
	char *delim;
	char *newlist;
	short i = 0;
	size_t len;

	len = strlen (newpage) + strlen(list) + 2;

	/* maybe we should put a check in here to see if len > 1024
	 * as this may choke NDBM ! */

	if ( (newlist = (char *) malloc (len)) == NULL)
		gripe_alloc(len, "newlist in orderthem");

	while ( (delim = strrchr(list, ':')) != NULL){
		*delim = '\0';
		substring[i++] = ++delim;
	}

	substring[i++] = list;
	substring[i++] = newpage;

	qsort( (void *) substring, i--, sizeof(char *) , (COMPARE_FN) compare);

	*newlist = '\0';
	
	while (i >= 0){
		strcat(newlist, substring[i]);
		if (i-- > 0)
			strcat(newlist, ":");
	}
	return newlist;
}
