/*
	Header file to make programming independent of dbm type used
	Currently satisfies gdbm and ndbm
*/

/*
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#ifdef SECURE_MAN_UID
#define MODE 0644  			/* mostly for setuid operation */
#else
#define MODE 0666			/* anyone */
#endif

#ifndef NDBM

#include <gdbm.h>
#ifndef GDBM_FAST
#define GDBM_FAST	0 		/* for gdbm versions < 1.6 */
#endif

#define BLK_SIZE			0  /* to invoke normal fs block size */
#define DB_EXT				".db"
#define MYDBM_FILE 			GDBM_FILE
#define MYDBM_OPEN(file)		gdbm_open(file, BLK_SIZE, GDBM_NEWDB|GDBM_FAST, MODE, 0)
#define MYDBM_CRWOPEN(file)		gdbm_open(file, BLK_SIZE, GDBM_WRCREAT|GDBM_FAST, MODE, 0)
#define MYDBM_RWOPEN(file)		gdbm_open(file, BLK_SIZE, GDBM_WRITER|GDBM_FAST, MODE, 0) 
#define MYDBM_REOPEN(file)		gdbm_open(file, BLK_SIZE, GDBM_READER, MODE, 0)
#define MYDBM_INSERT(dbf, key, cont)	gdbm_store(dbf, key, cont, GDBM_INSERT)
#define MYDBM_REPLACE(dbf, key, cont) 	gdbm_store(dbf, key, cont, GDBM_REPLACE)
#define MYDBM_DEL			gdbm_delete
#define MYDBM_FETCH			gdbm_fetch
#define MYDBM_CLOSE 			gdbm_close
#define MYDBM_FIRSTKEY			gdbm_firstkey
#define MYDBM_NEXTKEY(dbf, key)		gdbm_nextkey(dbf, key)
#define MYDBM_REORG(dbf)		gdbm_reorganize(dbf)
#define MYDBM_FREE(x)			free(x)

#else

#include <ndbm.h>
#include <fcntl.h>

#define DB_EXT				""
#define MYDBM_FILE 			DBM*
#define MYDBM_OPEN(file)		dbm_open(file, O_CREAT|O_TRUNC|O_RDWR, MODE)
#define MYDBM_CRWOPEN(file)             dbm_open(file, O_CREAT|O_RDWR, MODE)
#define MYDBM_RWOPEN(file)		dbm_open(file, O_RDWR, MODE)
#define MYDBM_REOPEN(file)		dbm_open(file, O_RDONLY, MODE)
#define MYDBM_INSERT(dbf, key, cont)	dbm_store(dbf, key, cont, DBM_INSERT)
#define MYDBM_REPLACE(dbf, key, cont)   dbm_store(dbf, key, cont, DBM_REPLACE)
#define MYDBM_DEL			dbm_delete
#define MYDBM_FETCH	 		dbm_fetch
#define MYDBM_CLOSE 			dbm_close
#define MYDBM_FIRSTKEY			dbm_firstkey
#define MYDBM_NEXTKEY(dbf, key)		dbm_nextkey(dbf)
#define MYDBM_REORG(dbf)		/* nothing - not implemented */
#define MYDBM_FREE(x)			/* nothing - not needed */

#endif
