#!/bin/sh
#
# mkcatdirs.sh - create necessary directories for FSSTND compilant manbrowser
#
# part of the man-2.0a package maintained by Wilf <...>
#
# written 5-Jul-94 by Nils Magnus <nils@eriador.ruessel.sub.org>
#

PATH=/bin:/usr/bin

# Prepare the output file:

OUTPUT=./createcatdirs.sh
cat << EOT > ${OUTPUT}
#!/bin/sh
#
# createcatdirs.sh - actually create the cat tree
#
# This file is automaticaly created by mkcatdir.sh, so better don't edit.
#

EOT

# Search for directories named 'man':

cat << EOT
Creating necessary directories needed for a FSSTND compliant man pager.

Searching for existing man trees...

Answer whether the following directories should be considered in
creating cat trees (default is to include).

EOT

MANDIRS=`find /usr -name man -a -type d -print 2> /dev/null`

for dir in ${MANDIRS}; do
	echo -n "Would you like cat pages for ${dir} [y/n]? "
	read ans
	case ${ans} in
	n|no)
		echo "skipped ${dir}"
		;;
	y|yes|*)
		echo "added ${dir}"
		RMANDIRS="${RMANDIRS} ${dir}"
		;;
	esac
done

# Allow additional directories:

cat << EOT 

Are there any additional directories not mentioned above? This program will
only deal with tree under /usr at present.

Enter the path or hit RETURN to exit.
EOT

ans2="x"
while [ x${ans2}x != xx ]; do
	echo -n "Additional directory: "
	read ans2
	RMANDIRS="${RMANDIRS} ${ans2}"
done

# Process the directories:

for dir in ${RMANDIRS}; do

	# Create a /var/catman directory for each man tree 

	cdir=`echo ${dir} | sed -e 's%^/usr%/var/catman%;s%/man$%%'`
	echo "test -d ${cdir} || mkdir -p ${cdir}" >> ${OUTPUT}

	# create the cat? subdirectories for each cat tree

	for ssdir in ${dir}/man*; do
		ccdir="${cdir}/`echo ${ssdir} | sed -e 's%^.*/man%cat%'`"
		echo "test -d ${ccdir} || mkdir -p ${ccdir}" >> ${OUTPUT}
	done
done

# Add some commands for the right permissions

cat << EOT >> ${OUTPUT}

chown -R man.root /var/catman 
chmod -R u+w,go-w /var/catman

# End of createcatdirs.sh
EOT

cat << EOT

The commands necessary to create your cat tree were written into the
file createcatdirs.sh in this directory. May now may look over it and
adjust some details.

After this execute ./createcatdirs.sh as root.

EOT

# Give file execute and write permissions for the owner:

chmod u+w,a+rx ${OUTPUT} 

# End of mkcatdirs.sh

