/*
 * This file used to be part of manp.c (which actually used to be called
 * manpath.c) - see that file for copyright and other info.
 *
 * manpath.c: driver for the manpath routines
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#ifndef STDC_HEADERS
extern char *strcpy ();
extern int fflush ();
#endif

#include <unistd.h>
#include <stdio.h>

#include "config.h"

#ifdef HAS_GETOPT_LONG
#  include <getopt.h>
#endif /* HAS_GETOPT_LONG */

extern char *optarg;

char *mkprogname(char *s);
void ver(void);
char *manpath(int perrs, const char *systems);
char *cat_manpath(int perrs, char *systems);

char *prognam;
int debug;

#ifdef HAS_GETOPT_LONG
static struct option long_options[] =
{
    {"catpath", no_argument, 		0, 'c'},
    {"debug",   no_argument, 		0, 'd'},
    {"help",    no_argument, 		0, 'h'},
    {"quiet",   no_argument, 		0, 'q'},
    {"version", no_argument, 		0, 'V'},
    {"systems",  optional_argument, 	0, 'm'},
    {0, 0, 0, 0}
};
#endif /* HAS_GETOPT_LONG */

static char args[] = "cdhqVm:";

void usage(void)
{
	printf ("usage: %s [[-cdq] [-m system]] | [-V] | [-h]\n", prognam);
	printf ("-c --catpath                show relative catpaths.\n"
	        "-d --debug                  produce debugging info.\n"
	        "-q --quiet                  produce no warnings.\n"
	        "-m --systems system         include systems in manpath.\n"
	        "-V --version                show version.\n"
	        "-h --help                   show this usage message.\n");
}

/*
 * Examine user's PATH and print a reasonable MANPATH.
 */
int main (int argc, char *argv[])
{
	int c, quiet = 1;
	char *alt_system = NULL;
	short cat = 0;
	int option_index; /* not used, but required by getopt_long() */

	prognam = mkprogname (argv[0]);

#ifdef HAS_GETOPT_LONG

	while ((c = getopt_long (argc, argv, args,
				 long_options, &option_index)) != EOF){
#else /* HAS_GETOPT_LONG */

	while ((c = getopt (argc, argv, args)) != EOF){

#endif /* HAS_GETOPT_LONG */

		switch (c){

			case 'c':
				cat++;
				break;
			case 'd':
			    	debug++;
			    	break;
		    	case 'q':
			    	quiet--;
			    	break;
			case 'm':
				alt_system = optarg;
				break;
			case 'V':
				ver();
				exit(0);	
		    	case 'h':
		    	default:
		    		usage();
				exit(c != 'h');
		}
	}

	if (cat)
		printf ("%s\n", cat_manpath(quiet, alt_system));
	else
		printf ("%s\n", manpath (quiet, alt_system));

	return 0;
}
