/*
 * gripes.c
 *
 * Copyright (c) 1990, 1991, John W. Eaton.
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * John W. Eaton
 * jwe@che.utexas.edu
 * Department of Chemical Engineering
 * The University of Texas at Austin
 * Austin, Texas  78712
 *
 * Wed May  4 15:44:47 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk): changed a 
 * few fprintf()'s to fputs()'s.
 */

#include <stdio.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#else
extern int fprintf ();
extern int fflush ();
extern int exit ();
#endif

extern char *prognam;

void gripe_no_name (char *section)
{
	if (section)
		fprintf (stderr, "What manual page do you want from section %s?\n",
			 section);
	else
		fputs ("What manual page do you want?\n", stderr);

	fflush (stderr);
}

void gripe_reading_man_file (char *name)
{
	fprintf (stderr, "Read access denied for file %s\n", name);

	fflush (stderr);
}

void gripe_converting_name (char *name)
{
	fprintf (stderr, "Error converting %s to cat name\n", name);
	fflush (stderr);

	exit (1);
}

void gripe_system_command (int status)
{
	fputs ("Error executing formatting or display command.\n", stderr);
	fprintf (stderr, "system command exited with status %d\n", status);

	fflush (stderr);
}

void gripe_not_found (char *name, char *section, char *alt_system)
{
	char *sys, *systems;
	
	if (section)
		fprintf (stderr, "No manual entry for %s in section %s",
		  name, section);
	else
		fprintf (stderr, "No manual entry for %s", name);

	if (alt_system) {
		systems = strdup(alt_system);
		if ( (sys = strtok( systems, ",:")) ) {
			fprintf (stderr, " on system %s", sys);
			while( (sys = strtok(NULL, ",:")) )
				fprintf (stderr, " or %s", sys);
		}
		free(systems);
	}

	fputs(".\n", stderr);
	fflush (stderr);
}

void gripe_incompatible (char *s)
{
	fprintf (stderr, "%s: incompatible options %s\n", prognam, s);

	fflush (stderr);

	exit (1);
}

void gripe_getting_mp_config (char *file)
{
	fprintf (stderr, "%s: unable to find the file %s\n", prognam, file);

	fflush (stderr);

	exit (1);
}

void gripe_reading_mp_config (char *file)
{
	fprintf (stderr, "%s: unable to make sense of the file %s\n", prognam, file);

	fflush (stderr);

	exit (1);
}

void gripe_invalid_section (char *section)
{
	fprintf (stderr, "%s: invalid section (%s) selected\n", prognam, section);

	fflush (stderr);

	exit (1);
}

void gripe_manpath (void)
{
	fprintf (stderr, "%s: manpath is null\n", prognam);

	fflush (stderr);

	exit (1);
}

void gripe_alloc (int bytes, char *object)
{
	fprintf (stderr, "%s: can't malloc %d bytes for %s\n",
		 prognam, bytes, object);

	fflush (stderr);

	exit (1);
}

void gripe_roff_command_from_file (char *file)
{
	fprintf (stderr, "Error parsing *roff command from file %s\n", file);

	fflush (stderr);
}

void gripe_roff_command_from_env (void)
{
	fputs ("Error parsing MANROFFSEQ.  Using system defaults.\n", stderr);

	fflush (stderr);
}

void gripe_roff_command_from_command_line (char *file)
{
	fprintf (stderr, "Error parsing *roff command from command line. "
	  "file: %s\n", file);

	fflush (stderr);
}
