/*
 * convert_name.c
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * code to do appropriate pathname conversion
 *
 * Mon May  2 11:14:28 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "manpath.h"
#include "gripes.h"

extern int debug;

/*
 * Take manpath or manfile path as arg, return catdir mapping or NULL if
 * it isn't a global mandir.
 */
char *global_catpath(char *name)
{
	DIRLIST *dlp;
	char *catpath;
	extern DIRLIST list[]; /* mappings set up by manpath() */

	for (dlp = list; dlp->mandir[0] != '\0'; dlp++)
		if (dlp->mandatory == MANDB_MAP)
			if (strncmp(name, dlp->mandir, strlen(dlp->mandir))
			  == 0) {

			  	/* add the piece that's leftover */

			  	catpath = (char *) malloc (strlen(dlp->bin) +
			  	  strlen(name));
			  	strcpy(catpath, dlp->bin); 
			  	strcat(catpath, name + strlen(dlp->mandir));
			  	return catpath;
			}
	return NULL;
}		
	
/*
 * Change a name of the form ...man/man1/name.1 to ...man/cat1/name.1
 * 
 * OR for FSSTND, change name of form 	/usr/.../man/man1/name.1 to 
 *				   	/var/catman/.../cat1/name.1[.Z]
 */

char *convert_name (char *name, short var)
{
	char *to_name, *t1;
	char *t2 = NULL;
	size_t len;

#ifdef COMPRESS
	len = strlen (name) + sizeof COMPRESS_EXT;
	to_name = (char *) malloc (len);
	if (to_name == NULL)
		gripe_alloc (len, "to_name");
	strcpy (to_name, name);
	strcat (to_name, COMPRESS_EXT);
#else
	to_name = strdup (name);
#endif

	if (var && (t1 = global_catpath(to_name)) != NULL) {
		free(to_name);
		to_name = t1;
	}

	if ( (t1 = strrchr (to_name, '/')) != NULL) {

		*t1 = '\0';
		t2 = strrchr (to_name, '/');
	
		if (t2 == NULL)
			gripe_converting_name (name);

		*t1 = '/';

		*(t2 + 1) = 'c';
		*(t2 + 3) = 't';
	} else {
		fprintf(stderr, "Could not convert name %s, sorry.\n" , name);
		exit(1);
	}

	if (0) /* (debug) */
		fprintf (stderr, "to_name in convert_name () is %s\n", to_name);

	return to_name;
}

