/*
 * accessdb.c: show every key/content pair in the database.
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Tue Apr 26 12:56:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk) 
 */

#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include "mydbm.h"

char *prognam;

void dbver_rd(MYDBM_FILE dbf);

void usage(void)
{
	fprintf(stderr, "\nUsage: accessdb [man_database]\n"
	  "       default: " GLOBAL_DB "\n\n");
}

int main(int argc, char *argv[])
{
	MYDBM_FILE dbf;
	datum key,content;
	char *database;

	prognam = argv[0];

	if (argc > 2) {
		usage();
		exit(1);
	} else if (argc == 2) 
		database = argv[1];
	else
		database = GLOBAL_DB;
		

	if ( (dbf = MYDBM_REOPEN(database)) == NULL) {
		perror(database);
		usage();
		exit(1);
	}

	dbver_rd(dbf);

	key = MYDBM_FIRSTKEY(dbf);

	while (key.dptr != NULL) {
		content = MYDBM_FETCH(dbf, key);
		printf("%s -> %s\n", key.dptr, content.dptr); 
		MYDBM_FREE(content.dptr);
		key = MYDBM_NEXTKEY(dbf, key);
	}
	return 0;
}
