/* delete.c -- Delete a previously installed package
 * Created: Thu Sep 14 19:58:45 1995 by r.faith@ieee.org
 * Revised: Wed Oct 25 15:50:58 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: delete.c,v 1.2 1995/10/28 01:21:14 faith Exp $
 * 
 */

#include "pm.h"

static void pre_delete_script( List list )
{
   char *tmp = tempnam( PmTmp, PgmName );
   int  exitStatus;

   if (pm_notes_script( list, PM_PREDELETE, tmp, NULL )) {
      pm_chmod( tmp, 0700 );
      PRINTF(PM_VERBOSE,("(Running pre-deletion script)\n"));
      exitStatus = pm_shell( tmp );
   }
   pm_unlink( tmp );
}

static void post_delete_script( List list )
{
   char *tmp = tempnam( PmTmp, PgmName );
   int  exitStatus;

   if (pm_notes_script( list, PM_POSTDELETE, tmp, NULL )) {
      pm_chmod( tmp, 0700 );
      PRINTF(PM_VERBOSE,("(Running post-deletion script)\n"));
      exitStatus = pm_shell( tmp );
   }
   pm_unlink( tmp );
}

int delete( const char *name )
{
   const char *notesFile = pm_db_notesfile( name );
   List       list       = pm_notes_read( notesFile );
   
   if (TEST(PM_TIME)) pm_reset_timer();
   
   if (list) pre_delete_script( list );
   PRINTF(PM_TIME,("(Pre-deletion script: %ld mS)\n",pm_delta_time()));
   pm_db_delete_package( name );
   PRINTF(PM_TIME,("(Deleting files: %ld mS)\n",pm_delta_time()));
   if (list) post_delete_script( list );
   PRINTF(PM_TIME,("(Post-deletion script: %ld mS)\n",pm_delta_time()));
   if (list) pm_notes_free( list );
   if (notesFile) xfree( (char *)notesFile );
   
   PRINTF(PM_TIME,("(Deletion complete: %ld mS)\n",pm_total_time()));
   return 0;
}
