/* xmalloc.c -- Error-checking malloc
 * Created: Sun May  7 07:55:23 1995 by r.faith@ieee.org
 * Revised: Tue Dec 19 19:30:40 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: xmalloc.c,v 1.2 1995/12/20 05:04:56 faith Exp $
 */

#include "pmlib.h"

#if STDC_HEADERS
#include <stdlib.h>
#else
void *malloc();
void *calloc();
void *realloc();
void free();
#endif

#ifndef DMALLOC_FUNC_CHECK

void *xmalloc( unsigned int size )
{
   void *pt = malloc( size );

   if (!pt) pm_fatal( PMERR_NOCORE, "%ld bytes\n", size );
   return pt;
}

void *xcalloc( unsigned int num, unsigned int size )
{
   void *pt = calloc( num, size );

   if (!pt) pm_fatal( PMERR_NOCORE, "%ld X %ld byte block\n", num, size );
   return pt;
}

void *xrealloc( void *pt, unsigned int size )
{
   void *new = realloc( pt, size );

   if (!new) pm_fatal( PMERR_NOCORE,
		       "reallocating block at %p to %ld bytes\n", pt, size );
   return new;
}

void xfree( void *pt )
{
   if (pt) free( pt );
   else pm_fatal( PMERR_NULLPT, "\n" );
}

char *xstrdup( const char *s )
{
   char *pt = strdup( s );

   if (!pt) pm_fatal( PMERR_NOCORE, "duplicating string\n" );

   return pt;
}

#endif
