/* version.c -- Version
 * Created: Thu May  4 12:31:07 1995 by r.faith@ieee.org
 * Revised: Sun May  7 19:35:55 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: version.c,v 1.1 1995/05/13 19:07:13 faith Exp $
 * 
 */

#include "pmlib.h"

#define LIBPM_VERSION "libpm 1.0"

extern const char *PgmName;
extern const char *PgmVersion;

const char *pm_version( void )
{
   static char buffer[100];
   char        *pt;

   strcpy( buffer, PgmName );
   strcat( buffer, " " );
   
   if (strchr( PgmVersion, ':')) {
				/* Assume version is an RCS Revision string */
      strcat( buffer, strchr( PgmVersion, ':' ) + 2 );
      pt = strrchr( buffer, '$') - 1;
      if (!pt)                  /* Stripped RCS Revision string? */
            pt = buffer + strlen( buffer ) - 1;
      if (*pt != ' ')
            ++pt;
      *pt = '\0';
   } else {                     /* Assume version is a number */
      strcat( buffer, PgmVersion );
   }
   
   strcat( buffer, " (" );
   strcat( buffer, LIBPM_VERSION );
   strcat( buffer, ")" );
      
   return buffer;
}
