/* tartest.c -- Test program for tar support
 * Created: Thu May  4 09:15:08 1995 by r.faith@ieee.org
 * Revised: Tue May  9 12:02:24 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tartest.c,v 1.1 1995/05/13 19:07:13 faith Exp $
 * 
 */

#include "pmlib.h"
#include "tar.h"

const char *PgmName    = "TarTest";
const char *PgmVersion = "$Revision: 1.1 $";

int main( int argc, char **argv )
{
   FILE         *str;
   union record header;
   char         buffer[4096];
   char         *tmp;
   int          first = 1;

   if (argc < 2) return 0;

   sprintf( buffer, "zcat %s", argv[1] );
   if (!(str = popen( buffer, "r" ))) {
      fprintf( stderr, "Cannot open \"%s\" for read\n", argv[1] );
      perror( "" );
   }

   while (!pm_tar_next_header( str, &header )) {
      pm_tar_print_header( stdout, &header );
      if (first) {
	 long unsigned size = pm_tar_size( &header );
	 
	 tmp = pm_tar_read( str, &header );
	 if (tmp) {
	    CheckSum cksum = pm_checksum_buffer( tmp, size );
	    pm_checksum_print( stdout, cksum );
	    pm_checksum_free( cksum );
	    tmp[size > 70 ? 70 : size - 1] = '\0';
	    printf( "%s\n", tmp );
	    xfree( tmp );
	 }
	 first = 0;
      }
   }

   pclose( str );

   return 0;
}
