/* pmlib.h -- 
 * Created: Tue May  2 14:37:06 1995 by r.faith@ieee.org
 * Revised: Sat Jan  6 14:55:52 1996 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * $Id: pmlib.h,v 1.18 1996/01/06 21:49:34 faith Exp $
 * 
 */

#ifndef _PMLIB_H_
#define _PMLIB_H_

#include "pmconfig.h"
				/* Include pmdb.h last, due to dmalloc.h
                                   concerns -- see end of this file. */

#ifndef __GCC__
#define __inline__
#define __attribute__(x)
#endif

#ifndef EXTERN
#define EXTERN extern
#endif

/* Provide support for Colin Plumb's Public Domain MD5 implementation. */
#include "md5.h"

/* These are the names of the standard binaries for GNU tar (version 1.11.2
   (March 1993) or later), GNU gzip (version 1.2.4 (August 1993) or later),
   and Larry Wall's patch (version 2.1 (June 1993) or later), and
   Info-ZIP's unzip (version 5.0 (August 1992) or later).  Since these
   versions are about two years old as of this writing, it is expected that
   everyone in the world has installed them. */

#define PM_TAR_PROG                 "tar"
#define PM_GZIP_PROG                "gzip"
#define PM_PATCH_PROG               "patch"
#define PM_UNZIP_PROG               "unzip"

/* This is the string used to make old versions before deleting.  Assuming
   "old" is the string, shared libraries will be pre-pended with "old-" and
   all other files will be post-pended with ".old". */

#define PM_OLD                      "PmOld"

/* These are used in the build shell script.  If the build shell script can
   be written in something other than Bourne shell, then every use of these
   variables needs to be patched for the other interpreter.  See notes.c
   for details. */

#define PM_TAR_SOURCES              PM_TAR_PROG \
                   " chf - * | " PM_GZIP_PROG " -9c > %s"
#define PM_TAR_SOURCES_VERBOSE      PM_TAR_PROG \
                   " cvvhf - * | " PM_GZIP_PROG " -9c > %s"

#define PM_UNTAR_VERBOSE            PM_TAR_PROG " xvvf %s"
#define PM_UNTAR                    PM_TAR_PROG " xvvf %s >& /dev/null"

#define PM_UNTAR_COMPRESSED_VERBOSE \
                   PM_GZIP_PROG " -dc %s | " PM_TAR_PROG " xvvf -"
#define PM_UNTAR_COMPRESSED \
                   PM_GZIP_PROG " -dc %s | " PM_TAR_PROG " xvvf - >& /dev/null"

#define PM_UNZIP_VERBOSE            PM_UNZIP_PROG " -x %s"
#define PM_UNZIP                    PM_UNZIP_PROG " -xqq %s >& /dev/null"

#define PM_PATCH_COMPRESSED \
                   PM_GZIP_PROG " -dc %s | " PM_PATCH_PROG " %s -p%d -sf"
#define PM_PATCH_COMPRESSED_FILTER \
                   PM_GZIP_PROG " -dc %s | %s | " PM_PATCH_PROG " %s -p%d -sf"
#define PM_PATCH                    PM_PATCH_PROG " %s -p%d -sf < %s"
#define PM_PATCH_FILTER             "%s < %s | " PM_PATCH_PROG " %s -p%d -sf"

#define PM_UNCOMPRESSED 0
#define PM_COMPRESSED   1
#define PM_ZIPPED       2

/* These are used by the fork/exec routines.  Verbosity is handled by
   leaving stdout as the parent's stdout instead of dup'ing the child's
   stdout as /dev/null.  See exec.c for details.  Note that various tar's
   have different options and it is impossible to tell which tar we are
   using, so it would be nice if GNU tar was used all the time.  If this
   becomes a problem, it would be best to add these strings to the
   configuration file and to have a class of configuration variables which
   are not placed in the build script. */

#define PM_TARLIST_FILTER           "cvvSTf %s -"
#define PM_UNTAR_FILTER             "xvvpf -"
#define PM_UNTAR_FILTER_VERBOSE     "xvvpf -"
#define PM_GUNZIP_FILTER            "-dc"
#define PM_GZIP_FILTER              "-9c"

#define PM_BINARY_EXT               ".bin.tar.gz"
#define PM_SOURCE_EXT               ".src.tar.gz"

EXTERN int        PmNeedsLdconfig;
EXTERN int        PmTestFunction;
EXTERN time_t     PmTimeStamp;
EXTERN const char *PmTimeString;
EXTERN const char *PmCurrentNotesDir;


/* xmalloc.c */

#ifndef DMALLOC_FUNC_CHECK
extern __inline__ void *xmalloc( unsigned int size );
extern __inline__ void *xcalloc( unsigned int num, unsigned int size );
extern __inline__ void *xrealloc( void *pt, unsigned int size );
extern __inline__ void xfree( void *pt );
extern __inline__ char *xstrdup( const char *s );
#endif


/* debug.c */

extern unsigned int pm_debug_flags;
extern void pm_debug( const char *flag );

/* These values must represent a single bit */
#define PM_VERBOSE  0x00000001	/* Verbose */
#define PM_TAR      0x00000002	/* Tar debugging */
#define PM_CONFIG   0x00000004	/* Config debugging */
#define PM_NOTES    0x00000008	/* Notes debugging */
#define PM_FILE     0x00000010	/* File testing debugging */
#define PM_SEARCH   0x00000020	/* Debug file searching */
#define PM_EXEC     0x00000040	/* Debug fork/exec routines */
#define PM_CHILD    0x00000080	/* Report child exit status from wait(2) */
#define PM_NOCHROOT 0x00000100	/* Don't fork/chroot for installation */
#define PM_INSTALL  0x00000200	/* Verbose installation messages */
#define PM_STDERR   0x00000400	/* Don't suppress stderr */
#define PM_DB       0x00000800	/* Debug database access */
#define PM_TIME     0x00001000	/* Perform timings */
#define PM_DEBUG    0x10000000	/* Don't actually do anything */
#define PM_NEVER    0x80000000	/* Never used */

#define PRINTF(flag,arg) if (pm_debug_flags&(flag)) printf arg
#define TEST(flag)       (pm_debug_flags&(flag))


/* list.c */

typedef struct List {
   int  count;
   int  maximum;
   char **lines;
} *List;

extern List pm_list_create( void );
extern List pm_list_add( List list, const char *string );
extern List pm_list_stream( FILE *str );
extern List pm_list_file( const char *filename );
extern void pm_list_iterate( List list, int (*f)( const char * ) );
extern void pm_list_write( FILE *str, List list );
extern void pm_list_free( List list );


/* config.c */

EXTERN const char *PmDistribution;
EXTERN const char *PmRoot;
EXTERN const char *PmBuildDir;
EXTERN const char *PmBuildSubDir;
EXTERN const char *PmSourceDir;
EXTERN const char *PmNotesDir;
EXTERN const char *PmDocDir;
EXTERN const char *PmInfoDir;
EXTERN const char *PmSrcDistDir;
EXTERN const char *PmBinDistDir;
EXTERN const char *PmNotesExt;
EXTERN const char *PmPatchExt;
EXTERN const char *PmSrcExt;
EXTERN const char *PmBinExt;
EXTERN const char *PmTarRoot;
EXTERN const char *PmInstRoot;
EXTERN const char *PmTmp;
EXTERN const char *PmDBDir;
EXTERN const char *PmPath;
EXTERN const char *PmBourneShell;
EXTERN int        PmUseGroup;
EXTERN int        PmForceGroup;
EXTERN int        PmUmask;
EXTERN int        PmForceInstall;
EXTERN int        PmHash;
EXTERN int        PmQuiet;
EXTERN int        PmPedantic;
EXTERN int        PmNoDatabase;

extern void pm_config( const char *extra );
extern void pm_shutdown( void );
extern void pm_config_env( FILE *str );


/* entry.c */

#define PM_TYPE_CONFIG    'C'
#define PM_TYPE_DIRECTORY 'D'
#define PM_TYPE_REGULAR   'F'

#define PM_KIND_UNKNOWN   '?'
#define PM_KIND_REGULAR   'f'
#define PM_KIND_SYMLINK   'l'
#define PM_KIND_DIRECTORY 'd'
#define PM_KIND_CHAR      'c'
#define PM_KIND_BLOCK     'b'
#define PM_KIND_FIFO      'p'
#define PM_KIND_SOCKET    's'

typedef struct PmEntry {
   char    *name;		/* path */
   char    type;		/* F = file, D = dir, C = config */
   char    kind;		/* file type, as from ls */
   size_t  size;		/* in bytes */
   umode_t mode;		/* full mode from stat */
   time_t  mtime;		/* modification time */
   dev_t   device;		/* device */
   char    *user;		/* user */
   char    *group;		/* group */
   char    *checksum;		/* checksum */
   char    *link;		/* file linked to if hard or sym link */
} *PmEntry;

typedef struct PmEntryList {
   PmEntry            entry;
   struct PmEntryList *next;
   struct PmEntryList *tail;
} *PmEntryList;

extern void          pm_entry_init( void );
extern void          pm_entry_shutdown( void );
extern PmEntry       pm_entry_create( const char *filename );
extern void          pm_entry_free( PmEntry entry );
extern void          pm_entry_write( FILE *str, PmEntry entry );
extern PmEntry       pm_entry_parse( const char *line );
extern PmEntryList   pm_entry_list_create( void );
extern void          pm_entry_list_add( PmEntryList list, PmEntry entry );
extern void          pm_entry_list_free( PmEntryList list );
extern void          pm_entry_list_print( FILE *str,
					  PmEntryList list,
					  int verbosity );
extern int           pm_entry_list_count( PmEntryList list );
extern unsigned long pm_entry_list_size( PmEntryList list );

/* notes.c */

EXTERN const char *PmPkgDescription;
EXTERN const char *PmPkgName;
EXTERN const char *PmPkgVersion;
EXTERN const char *PmPkgCopyright;
EXTERN const char *PmPkgRelease;
EXTERN const char *PmPkgCompiler;
EXTERN const char *PmPkgLibraries;
EXTERN const char *PmPkgCompiledBy;
EXTERN const char *PmPkgDateCompiled;
EXTERN const char *PmPkgGroup;
EXTERN const char *PmPkgDistribution;
EXTERN const char *PmPkgInterpreter;
EXTERN const char *PmPkgHaveFiles;
EXTERN const char *PmPkgHaveDistFiles;
EXTERN const char *PmPkgSubName;

#define PM_MAXSOURCE 20
#define PM_MAXPATCH  30

EXTERN const char *PmPkgSource[PM_MAXSOURCE];
EXTERN const char *PmPkgPatch[PM_MAXPATCH];

#define PM_PREP        0x00000001
#define PM_BUILD       0x00000002
#define PM_INST        0x00000004
#define PM_PACK        0x00000008
#define PM_PACKSOURCE  0x00000010
#define PM_CLEAN       0x00000100
#define PM_REPREP      0x00000200

#define PM_PREINSTALL  0x00001000
#define PM_POSTINSTALL 0x00002000
#define PM_FILES       0x00010000
#define PM_DISTFILES   0x00020000
#define PM_PREDELETE   0x00100000
#define PM_POSTDELETE  0x00200000

extern void       pm_notes_header( FILE *str, const char *subName );
extern List       pm_notes_read( const char *filename );
extern List       pm_notes_read_tar( const char *filename );
extern void       pm_notes_parse( List list );
extern void       pm_notes_free( List list );
extern void       pm_notes_check( int flag );
extern void       pm_notes_make_hierarchy( FILE *str, const char *path );
extern void       pm_notes_build_ancillary( List type, List field );


/* notes-script.c */

extern int        pm_notes_script( List list,
				   unsigned int level,
				   const char *filename,
				   const char *packCommand );
extern char       *pm_notes_env_name( const char *name );


/* notes-copy.c */

extern void       pm_notes_copy( List list, List files, const char *subName );


/* notes-file.c */

extern List        pm_notes_files( List list, const char *subName );
extern List        pm_notes_files_sections( List list );
extern PmEntryList pm_notes_files_dist( List list );


/* error.c */
				/* Global error messages */
#define PMERR_HELP       1	/* User requested help */
#define PMERR_INVDBFLG   2	/* Invalid debug flag */
#define PMERR_INVCNFG    3	/* Invalid config entry  */
#define PMERR_INVUSER    4	/* Invalid username */
#define PMERR_INVSETUP   5	/* Invalid %setup flag */
#define PMERR_INVPATCH   6	/* Invalid %patch flag */
#define PMERR_INVMACRO   7	/* (Possibly) invalid macro */
#define PMERR_INTERNAL   8	/* Internal error -- can't happen */
#define PMERR_NOUSER     9	/* Can't find username for this process */
#define PMERR_NOGROUP   10	/* Can't find group name for this process */
#define PMERR_NOFILE    11	/* Can't find file */
#define PMERR_NOMATCH   12	/* No match for glob(3) */
#define PMERR_STAT      13	/* Can't stat file  */
#define PMERR_LSTAT     14	/* Can't lstat file */
#define PMERR_EOF       15	/* Unexpected end of file */
#define PMERR_READOPEN  16	/* Cannot open for read */
#define PMERR_WRITEOPEN 17	/* Cannot open for write */
#define PMERR_TOOLONG   18	/* Name too long (user or group) */
#define PMERR_DIROPEN   19	/* Cannot read dierctory */
#define PMERR_CHILDREN  20	/* Children exist (internal error) */
#define PMERR_CHILDERR  21	/* Child failed */
#define PMERR_SCRIPTERR 22	/* Script failed */
#define PMERR_PIPE      23	/* Pipe error */
#define PMERR_FORK      24	/* Fork error */
#define PMERR_EXEC      25	/* Exec error */
#define PMERR_NOCORE    26	/* Out of memory */
#define PMERR_NULLPT    27	/* Attempt to free null pointer */
#define PMERR_SIG       28	/* Signal handling problem */
#define PMERR_SIGNAL    29	/* Caught signal */
#define PMERR_NONOTES   30	/* No notes file */
#define PMERR_NOTAR     31	/* No distribution file */
#define PMERR_NOPATCH   32	/* No patch file */
#define PMERR_NOSOURCE  33	/* No source file */
#define PMERR_AMBIG     34	/* Ambiguous notes file name */
#define PMERR_BUILD     35	/* Build failed */
#define PMERR_PACK      36	/* Pack failed */
#define PMERR_INST      37	/* Install failed */
#define PMERR_FILESMAC  38	/* Files macro has too many arguments */
#define PMERR_TAR       39	/* Error reading tar file */
#define PMERR_UNTAR     40	/* Error untar'ing file */
#define PMERR_READLINK  41	/* Cannot read link */
#define PMERR_NOTES     42	/* Error in notes files */
#define PMERR_NODB      43	/* Can't open/create database */
#define PMERR_DBCLOSE   44	/* Can't close database */
#define PMERR_INSTCONF  45	/* Installation conflicts */
#define PMERR_NOPACKAGE 46	/* Cannot locate package in database */
#define PMERR_RELATIVE  47	/* Cannot handle relative path */
#define PMERR_NOHOST    48      /* Cannot find host name */
#define PMERR_DBOPEN    49	/* Database already open */
#define PMERR_DBCLOSED  50	/* Database already closed */
#define PMERR_DBSHUT    51	/* Database needed shutdown */

extern void pm_fatal( unsigned int message, const char *format, ... )
   __attribute__((noreturn,format(printf, 2, 3)));
extern void pm_warning( unsigned int message, const char *format, ... )
   __attribute__((format(printf, 2, 3)));


/* checksum.c */

typedef void *CheckSum;

extern CheckSum   pm_checksum_file( const char *filename );
extern CheckSum   pm_checksum_buffer( const char *buffer, unsigned length );
extern void       pm_checksum_print( FILE *str, CheckSum cksum );
extern const char *pm_checksum_tostring( CheckSum cksum );
extern CheckSum   pm_checksum_fromstring( const char *string );
extern int        pm_checksum_compare( CheckSum cksum1, CheckSum cksum2 );
extern void       pm_checksum_free( CheckSum cksum );


/* tar.c */

typedef void *TarHeader;

extern TarHeader     pm_tar_alloc_header( void );
extern void          pm_tar_free_header( TarHeader header );
extern int           pm_tar_next_header( FILE *str, TarHeader header );
extern const char    *pm_tar_filename( TarHeader header );
extern unsigned long pm_tar_size( TarHeader header );
extern List          pm_tar_listify( FILE *str, TarHeader header );

extern void          pm_tar_print_header( FILE *str, TarHeader header );
extern char          *pm_tar_read( FILE *str, TarHeader header );


/* version.c */

extern const char *pm_version( void );


/* file.c */

#define PM_CONFIG_FLAG  '*'
#define PM_DEFAULT_FLAG ' '


extern const char *pm_file_readable( int count, ... );
extern const char *pm_file_path( int count, ... );
extern int        pm_file_compressed( const char *filename );
extern int        pm_buffer_compressed( const char *buf );
extern int        pm_file_nonempty_dir( const char *filename );
extern int        pm_file_expand( List list, const char *filename, int flag );
extern FILE       *pm_file_create( const char *filename );
extern FILE       *pm_file_read( const char *filename );
extern void       pm_file_close( FILE *str );
extern void       pm_file_hierarchy( const char *path, int makeFinal );


/* get.c */

extern const char *pm_get_user_name( void );
extern const char *pm_get_group_name( void );
extern const char *pm_get_host_name( void );
extern const char *pm_get_email_name( void );


/* exec.c */

extern int  pm_untar( const char *filename, int file, int compressed,
		      void (*f)( const char *line ) );
extern int  pm_tar( const char *listname,
		    const char *root,
		    const char *filename );
extern int  pm_shell( const char *command );
extern int  pm_gunzip_filter( int fd );
extern int  pm_gzip_filter( int fd );
extern int  pm_chroot( const char *root, int (*f)( void * ), void *param );
extern void pm_child_clear( void );
extern int  pm_child_wait( void );


/* sys.c */

extern int pm_chmod( const char *path, mode_t mode );
extern int pm_chown( const char *path, uid_t owner, gid_t group );
extern int pm_symlink( const char *oldpath, const char *newpath );
extern int pm_rename( const char *oldpath, const char *newpath );
extern int pm_unlink( const char *path );
extern int pm_mkdir( const char *path, mode_t mode );
extern int pm_rmdir( const char *path );
extern int pm_umask( int mask );


/* resolve.c */

extern const char *pm_resolve_notesfile( const char *name );
extern const char *pm_resolve_tarfile( const char *name, int *source );
extern const char *pm_resolve_patchfile( const char *name );
extern const char *pm_resolve_sourcefile( const char *name );
extern const char *pm_get_partial( const char *paths );
extern const char *pm_create_distpath( const char *path, const char *name );


/* gen.c */

extern const char *pm_gen_canonical( const char *subName );
extern const char *pm_gen_notespath( const char *subName );


/* argify.c */

extern List pm_argify( const char *line );

/* db.c */

extern void       pm_db_open( int writeFlag );
extern void       pm_db_close( void );
extern void       pm_db_install_package( PmEntryList entries,
					 List fileList, List dispList );
extern void       pm_db_check_previous_version( void );
extern int        pm_db_check_previous_file( const char *file );
extern void       pm_db_list_package_all( int longFlag );
extern void       pm_db_list_package_byname( const char *name, int longFlag );
extern const char *pm_db_get_checksum( const char *filename );
extern void       pm_db_rename( const char *oldname, const char *newname );
extern void       pm_db_delete_file( const char *filename );
extern void       pm_db_delete_package( const char *name );
extern void       pm_db_whence( const char *filename );
extern const char *pm_db_notesfile( const char *name );

/* time.c */
extern void       pm_reset_timer( void );
extern long int   pm_delta_time( void );
extern long int   pm_total_time( void );
				/* dmalloc must be last */
#ifdef DMALLOC_FUNC_CHECK
# include "dmalloc.h"
#endif

#endif
